---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: ストレージセル
  icon: item_storage_cell_1k
  position: 410
categories:
- tools
item_ids:
- ae2:item_cell_housing
- ae2:fluid_cell_housing
- ae2:cell_component_1k
- ae2:cell_component_4k
- ae2:cell_component_16k
- ae2:cell_component_64k
- ae2:cell_component_256k
- ae2:item_storage_cell_1k
- ae2:item_storage_cell_4k
- ae2:item_storage_cell_16k
- ae2:item_storage_cell_64k
- ae2:item_storage_cell_256k
- ae2:fluid_storage_cell_1k
- ae2:fluid_storage_cell_4k
- ae2:fluid_storage_cell_16k
- ae2:fluid_storage_cell_64k
- ae2:fluid_storage_cell_256k
---

# ストレージセル

<Column>
  <Row>
    <ItemImage id="item_storage_cell_1k" scale="4" />
    <ItemImage id="item_storage_cell_4k" scale="4" />
    <ItemImage id="item_storage_cell_16k" scale="4" />
    <ItemImage id="item_storage_cell_64k" scale="4" />
    <ItemImage id="item_storage_cell_256k" scale="4" />
  </Row>
  <Row>
    <ItemImage id="fluid_storage_cell_1k" scale="4" />
    <ItemImage id="fluid_storage_cell_4k" scale="4" />
    <ItemImage id="fluid_storage_cell_16k" scale="4" />
    <ItemImage id="fluid_storage_cell_64k" scale="4" />
    <ItemImage id="fluid_storage_cell_256k" scale="4" />
  </Row>
</Column>

ストレージセルは、Applied Energisticsにおける主要なストレージ手段の1つです。  
これらは<ItemLink id="drive" />や<ItemLink id="chest" />に挿入して使用します。

容量の仕組みについては、[バイトとタイプ](../ae2-mechanics/bytes-and-types.md)を参照してください。

セルが空であれば、Shift＋右クリックすることで、ストレージコンポーネントをハウジングから取り外すことができます。

<Row>
  <Recipe id="upgrade/item_storage_cell_1k_to_4k" />
  ストレージセルは、より上位のストレージコンポーネントとクラフトグリッドで組み合わせることでアップグレードできます。中身は保持され、下位のコンポーネントは返却されます。
</Row>

## タイプ数によるストレージ容量の変化

[タイプの初期コスト](../ae2-mechanics/bytes-and-types.md)の影響により、1種類のアイテムのみを格納する場合、  
63種類すべてを使用する場合の約2倍の容量を確保できます。

| セル                                     | 1種類のみ使用時の総容量 | 63種類使用時の総容量 |
| ---------------------------------------- | -------------------------: | --------------------------: |
| <ItemLink id="item_storage_cell_1k" />   |                      8,128 |                       4,160 |
| <ItemLink id="item_storage_cell_4k" />   |                     32,512 |                      16,640 |
| <ItemLink id="item_storage_cell_16k" />  |                    130,048 |                      66,560 |
| <ItemLink id="item_storage_cell_64k" />  |                    520,192 |                     266,240 |
| <ItemLink id="item_storage_cell_256k" /> |                  2,080,768 |                   1,064,960 |

## 仕分け（パーティショニング）

セルは、<ItemLink id="storage_bus" />のように、特定のアイテムのみを受け入れるようフィルターを設定できます。  
これは<ItemLink id="cell_workbench" />で行います。

手元にアイテムがなくても、JEI/REIからスロットにドラッグすることでフィルターに設定できます。

## アップグレード

ストレージセルは、<ItemLink id="cell_workbench" />を使って以下の[アップグレードカード](upgrade_cards.md)に対応しています：

* <ItemLink id="fuzzy_card" />（液体セルでは使用不可）：ダメージ値やNBTを無視して仕分けが可能になります  
* <ItemLink id="inverter_card" />：ホワイトリストとブラックリストを切り替えます  
* <ItemLink id="equal_distribution_card" />：セルのバイト容量を各アイテムタイプに均等に割り当て、1種類がセル全体を占有するのを防ぎます  
* <ItemLink id="void_card" />：セルが満杯、または該当タイプの容量を超えた場合にアイテムを破棄します（特にファームの詰まり防止に便利。仕分け設定を忘れずに！）  
* 携帯型セルでは、<ItemLink id="energy_card" />を使ってバッテリー容量を拡張できます

## 染色

携帯型アイテムセルおよび液体セルは、染料とクラフトすることで革防具のように染色できます。

# ハウジング

セルは、ストレージコンポーネントとハウジングを組み合わせて作ることができます。また、ハウジングレシピでコンポーネントを囲って作ることも可能です。

<Row>
  <Recipe id="network/cells/item_storage_cell_1k" />
  <Recipe id="network/cells/item_storage_cell_1k_storage" />
</Row>

ハウジング単体のクラフトレシピは以下の通りです：

<Row>
  <RecipeFor id="item_cell_housing" />
  <RecipeFor id="fluid_cell_housing" />
</Row>

# ストレージコンポーネント

ストレージコンポーネントは、すべてのAE2セルの中核を成すもので、セルの容量を決定します。  
各ティアは前のティアの3個を材料にして作られ、容量は4倍になります。

<Column>
  <Row>
    <RecipeFor id="cell_component_1k" />

    <RecipeFor id="cell_component_4k" />

    <RecipeFor id="cell_component_16k" />
  </Row>

  <Row>
    <RecipeFor id="cell_component_64k" />

    <RecipeFor id="cell_component_256k" />
  </Row>
</Column>

# アイテムストレージセル

アイテムストレージセルは最大63種類のアイテムを保存でき、すべての標準容量で利用できます。

<Column>
  <Row>
    <Recipe id="network/cells/item_storage_cell_1k_storage" />

    <Recipe id="network/cells/item_storage_cell_4k_storage" />

    <Recipe id="network/cells/item_storage_cell_16k_storage" />
  </Row>

  <Row>
    <Recipe id="network/cells/item_storage_cell_64k_storage" />

    <Recipe id="network/cells/item_storage_cell_256k_storage" />
  </Row>
</Column>

## 携帯用アイテムストレージ

これらはポケットに入る小さな<ItemLink id="chest" />のようなもので、バックパックのように使えます。<ItemLink id="charger" />で充電できます。

標準のストレージセルとは異なり、バイト容量が増えるほど種類の保存上限が*減少*し、合計バイト容量も半分になります。

すべてのセルが対応しているアップグレードカードに加えて、これらには内部バッテリーを強化できる<ItemLink id="energy_card" />も使用できます。

<Column>
  <Row>
    <RecipeFor id="portable_item_cell_1k" />

    <RecipeFor id="portable_item_cell_4k" />

    <RecipeFor id="portable_item_cell_16k" />
  </Row>

  <Row>
    <RecipeFor id="portable_item_cell_64k" />

    <RecipeFor id="portable_item_cell_256k" />
  </Row>
</Column>

# 液体ストレージセル

液体ストレージセルは最大5種類の液体を保存でき、すべての標準容量で利用できます。

<Column>
  <Row>
    <Recipe id="network/cells/fluid_storage_cell_1k_storage" />

    <Recipe id="network/cells/fluid_storage_cell_4k_storage" />

    <Recipe id="network/cells/fluid_storage_cell_16k_storage" />
  </Row>

  <Row>
    <Recipe id="network/cells/fluid_storage_cell_64k_storage" />

    <Recipe id="network/cells/fluid_storage_cell_256k_storage" />
  </Row>
</Column>

## 携帯用液体ストレージ

これらはポケットに入る小さな<ItemLink id="chest" />のようなもので、バックパックのように使えます。<ItemLink id="charger" />で充電できます。

標準のストレージセルとは異なり、バイト容量が増えるほど種類の保存上限が*減少*し、合計バイト容量も半分になります。

すべてのセルが対応しているアップグレードカードに加えて、これらには内部バッテリーを強化できる<ItemLink id="energy_card" />も使用できます。

<Column>
  <Row>
    <RecipeFor id="portable_fluid_cell_1k" />

    <RecipeFor id="portable_fluid_cell_4k" />

    <RecipeFor id="portable_fluid_cell_16k" />
  </Row>

  <Row>
    <RecipeFor id="portable_fluid_cell_64k" />

    <RecipeFor id="portable_fluid_cell_256k" />
  </Row>
</Column>

# クリエイティブストレージセル

<Row>
  <ItemImage id="creative_storage_cell" scale="2" />
</Row>

クリエイティブセルは**無限のストレージを提供するわけではありません**。  
代わりに、[パーティション設定](cell_workbench.md)されたアイテムまたは液体の無限の供給源や排出口として機能します。
