---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: 量子ネットワークブリッジ
  icon: quantum_ring
  position: 110
categories:
- network infrastructure
item_ids:
- ae2:quantum_link
- ae2:quantum_ring
---

# 量子ネットワークブリッジ

![A formed Quantum Network Bridge](../assets/diagrams/quantum_bridge_demonstration.png)

量子ネットワークブリッジは、[ネットワーク](../ae2-mechanics/me-network-connections.md)を無限の距離や異なる次元間まで拡張できます。合計32チャネルを運搬でき、実質的にワイヤレスの[高密度ケーブル](cables.md#dense-cable)のように機能します。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/quantum_bridge_internal_structure_1.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/quantum_bridge_internal_structure_2.snbt" />

  <BoxAnnotation color="#33dd33" min="1 1 1" max="6 2 3">
    両端間の仮想ケーブル
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

注意: **両側ともチャンクロードしておく必要があります**。両側が離れている場合は<ItemLink id="spatial_anchor" />などのチャンクローダーを使用してください。

# 量子リング

<BlockImage id="quantum_ring" scale="8" />

<ItemLink id="quantum_link" />を中心にこれらのブロックを8つ設置すると、量子ネットワークブリッジが生成されます。<ItemLink id="quantum_link" />に隣接する4つの<ItemLink id="quantum_ring" />ブロックのみがネットワーク接続を受け付け、角に配置された4つのブロックはケーブルに接続できません。

## レシピ

<RecipeFor id="quantum_ring" />

# 量子リンクチャンバー

<BlockImage id="quantum_link" scale="8" />

<ItemLink id="quantum_ring" />に囲まれたこのブロック1つで量子ネットワークブリッジが完成します。このブロックはケーブルに接続せず、ブリッジが完成したときにのみネットワークの一部として登録されます。

このブロックのインベントリは<ItemLink id="quantum_entangled_singularity" />を1つだけ保持でき、自動化アクセスが可能です。

## レシピ

<RecipeFor id="quantum_link" />
