---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: P2Pトンネル
  icon: me_p2p_tunnel
  position: 210
categories:
- devices
item_ids:
- ae2:me_p2p_tunnel
- ae2:redstone_p2p_tunnel
- ae2:item_p2p_tunnel
- ae2:fluid_p2p_tunnel
- ae2:fe_p2p_tunnel
- ae2:light_p2p_tunnel
---

# P2Pトンネル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_tunnels.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

P2Pトンネルは、アイテム、流体、レッドストーン信号、電力、光、[チャネル](../ae2-mechanics/channels.md)などを、ネットワークに直接影響を与えずに転送するための手段です。各種P2Pトンネルはそれぞれ特定の種類のものだけを輸送し、本質的には距離を越えて2つのブロック面を直接接続するポータルのように機能します。双方向ではなく、入力と出力が明確に定義されています。

![Portal](../assets/assemblies/p2p_portal.png)

たとえば、アイテムP2Pトンネルに面したホッパーは、まるで樽に直接接続されているかのように動作し、アイテムを流します。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_hopper_barrel.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

ただし、隣り合った2つの樽同士ではアイテムは移動しません。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_barrel_barrel.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Redstone P2Pなどの他のバリアントもあります。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_redstone.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

さらに、チャネルを移動させるME P2Pトンネルも存在します。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_channels.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## P2Pトンネルの種類と調律

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_tunnels.snbt" />
  <IsometricCamera yaw="180" pitch="90" />
</GameScene>

多数のP2Pトンネルがあり、ME P2Pトンネルのみが直接クラフト可能で、その他は特定のアイテムで右クリックして作成します:
- ME P2Pトンネル: 任意の[ケーブル](../items-blocks-machines/cables.md)で右クリック  
- レッドストーンP2Pトンネル: 各種レッドストーン部品で右クリック  
- アイテムP2Pトンネル: チェストまたはホッパーで右クリック  
- 流体P2Pトンネル: バケツまたはボトルで右クリック  
- エネルギーP2Pトンネル: ほとんどのエネルギーを含むアイテムで右クリック  
- ライトP2Pトンネル: 松明またはグロウストーンで右クリック  

いくつかのトンネルには特有の動作があります。たとえば、ME P2Pトンネルのチャネルは他のME P2Pトンネルを通過できず、エネルギーP2PトンネルはFEを流す際に2.5%の税を間接的に徴収します（自身の[エネルギー](../ae2-mechanics/energy.md)消費を増加させることで）。

## 最もよく使われるP2Pの形態

P2Pトンネルで最も一般的な用途は、ME P2Pトンネルを使って[チャネル](../ae2-mechanics/channels.md)輸送の密度を圧縮することです。複数の太いケーブルの代わりに、1本の高密度ケーブルで多数のチャネルを運べます。

以下の例では、8つのME P2P入力がメインネットワークの<ItemLink id="controller" />から256
