---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: MEフォーメーションプレーン
  icon: formation_plane
  position: 210
categories:
- devices
item_ids:
- ae2:formation_plane
---

# MEフォーメーションプレーン

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/formation_plane.snbt" />
</GameScene>

MEフォーメーションプレーンはブロックを配置し、アイテムをドロップします。挿入専用の<ItemLink id="storage_bus" />と同様に動作し、<ItemLink id="import_bus" />や<ItemLink id="interface" />などの[デバイス](../ae2-mechanics/devices.md)が[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)に“格納”した際に配置／ドロップを行います。

<GameScene zoom="8" interactive={true}>
  <ImportStructure src="../assets/assemblies/formation_plane_demonstration.snbt" />
  <IsometricCamera yaw="255" pitch="30" />
</GameScene>

これらは[pipe subnets](../example-setups/pipe-subnet.md)におけるimport bus→storage busやinterface→storage busのパイプと同様の役割を果たします。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/import_storage_pipe.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_storage_pipe.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

本デバイスは[pipe subnets](../example-setups/pipe-subnet.md)などでストレージバスが利用するメカニズムを応用しており、アイテムを輸送する代わりにドロップ／配置したい場合に、それらの構成でストレージバスの代替として使用できます。

ケーブルサブパートとしても機能します（[ケーブルサブパート](../ae2-mechanics/cable-subparts.md)参照）。

**チャンク領域でフェイクプレイヤーを有効にすることを忘れないでください**

## フィルタリング

デフォルトではあらゆるアイテムを配置／ドロップします。フィルタースロットにアイテムを挿入すると、そのアイテムのみを許可するホワイトリストとして機能します。

JEI/REIからアイテムや流体をドラッグ＆ドロップしてフィルターに登録できます（実際に所有していなくても可）。

バケツや流体タンクなどの流体コンテナを右クリックすると、コンテナアイテムではなく中身の流体をフィルターとして設定できます。

## 優先度

GUI右上のレンチアイコンをクリックして優先度を設定できます。  
ネットワークに流入したアイテムは、まず優先度の高いストレージが最初の行き先になります。

## 設定

*   ブロックをワールド内に配置するか、アイテムをドロップするか設定できる。

## アップグレード

MEフォーメーションプレーンは以下の[アップグレード](upgrade_cards.md)をサポートします：

*   <ItemLink id="capacity_card" />を装着するとフィルタースロット数を増やせる。  
*   <ItemLink id="fuzzy_card" />を装着すると耐久度やNBTを無視してフィルタリングできる。  
*   <ItemLink id="inverter_card" />を装着するとフィルターをホワイトリストからブラックリストに切り替えられる。  

## レシピ

<RecipeFor id="formation_plane" />
