---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: エネルギーセル
  icon: energy_cell
  position: 110
categories:
- network infrastructure
item_ids:
- ae2:energy_cell
- ae2:dense_energy_cell
- ae2:creative_energy_cell
---

# エネルギーセル

<Row gap="20">
  <BlockImage id="energy_cell" scale="8" p:fullness="4" />

  <BlockImage id="dense_energy_cell" scale="8" p:fullness="4" />

  <BlockImage id="creative_energy_cell" scale="8" />
</Row>

エネルギーセルはネットワークに追加の[エネルギー](../ae2-mechanics/energy.md)貯蔵を供給します。  
多少のエナジーバッファがあることで、大量のアイテムを出し入れする際のエネルギー消費ピークを緩和し、  
より大容量の貯蔵により（夜間のソーラーパネル非発電時や大規模な[空間ストレージ](../ae2-mechanics/spatial-io.md)の瞬間的な消費にも）  
ネットワークを安定稼働させられます。

## バー表示

<Row>
  <BlockImage id="energy_cell" scale="4" p:fullness="0" />
  <BlockImage id="energy_cell" scale="4" p:fullness="1" />
  <BlockImage id="energy_cell" scale="4" p:fullness="2" />
  <BlockImage id="energy_cell" scale="4" p:fullness="3" />
  <BlockImage id="energy_cell" scale="4" p:fullness="4" />
</Row>

セル側面のバーは、内部エネルギー残量に応じて以下のように表示されます：

* 充電量が25%未満の場合は「0」を示す  
* 充電量が25%以上50%未満の場合は「1」を示す  
* 充電量が50%以上75%未満の場合は「2」を示す  
* 充電量が75%以上99%未満の場合は「3」を示す  
* 充電量が99%以上の場合は「4」を示す  

## セルの種類

* <ItemLink id="energy_cell" />は200k AEを蓄えられる。通常のネットワーク運用における電力サージを容易に補える。  
* <ItemLink id="dense_energy_cell" />は1.6M AEを蓄えられる。蓄電でネットワークを稼働させたい場合や、大規模な[空間ストレージ](../ae2-mechanics/spatial-io.md)の  
  瞬間消費に対応したい場合に最適。  
* <ItemLink id="creative_energy_cell" />はテスト用のクリエイティブアイテムで、無限の電力を供給できる。  

## レシピ

<Row>
  <RecipeFor id="energy_cell" />

  <RecipeFor id="dense_energy_cell" />
</Row>
