---
navigation:
  parent: example-setups/example-setups-index.md
  title: ストレージの種類とネットワークの整理
  icon: drive
---

# さまざまなストレージの種類とネットワークを整理する方法

フィルター、[パーティション](../items-blocks-machines/cell_workbench.md)、および[ストレージ優先度](../ae2-mechanics/import-export-storage.md#storage-priority)を使用して、さまざまな用途向けに複数のストレージ階層を構築できます。

ストレージの種類は主に以下のとおりです。

* **保管できる汎用ストレージ。**  
  数個から数千個程度のアイテムを扱えます。4kや16kなどの小型[セル](../items-blocks-machines/storage_cells.md)を使用します。  
* **保管できる大量ストレージ。**  
  数千個以上のアイテム（丸石や鉄など）を扱えます。256kやMEGAアドオンの[セル](../items-blocks-machines/storage_cells.md)など大容量のものを使います。  
* **提供できるファーム向けローカルストレージ。**  
  [Specialized Local Storage](specialized-local-storage.md) および [さまざまな](simple-certus-farm.md) [サータスクォーツ](semiauto-certus-farm.md) [ファーム](advanced-certus-farm.md)で説明されている方法です。  

優先度は、アイテムがメインネットワークに投入されたとき、まず専用の大量ストレージまたはローカルストレージに格納を試み、（フィルターやパーティションの制約で）格納できない場合は汎用ストレージに振り分けるよう設定されています。このため、アイテムはストレージ間を能動的に移動しませんが、ネットワークへの出入りのたびに“マイグレート”します。能動的に移動させたい場合は、<ItemLink id="io_port" />を使用してください。

<GameScene zoom="3" interactive={true}>
  <ImportStructure src="../assets/assemblies/network_storage_types.snbt" />

  <BoxAnnotation color="#33dd33" min="11 0 1" max="12 1.3 2" thickness="0.05">
    大量ストレージ。ここでは、ドロワーなどの大容量ストレージに接続したフィルタ付きストレージバスを使用しています。このストレージバスは石炭専用でフィルタ設定されており、優先度が高いため、石炭がネットワークに入るとこのストレージバスに格納され、ネットワークから取り出すときも*ここ以外*からではなく常にこのバスから引き出されるため、石炭はこのドロワーへ“マイグレート”します。

    重要な注意: ドロワーのような最適化された大容量インベントリは問題ありませんが、スロット数が多い*非*最適化インベントリ（例: コロッサルチェスト）は、ストレージバスと併用するとパフォーマンスが著しく低下します。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="11 0 3" max="12 1 4" thickness="0.05">
    大量ストレージ。ここでは優先度の高いドライブに搭載された256kセルをパーティション分割しています。このセルは丸石と鉄にパーティション設定されており、均等分配カードが装着されているので、丸石でセルが完全に埋まって鉄のスペースがなくなることはありません。ドライブの優先度も高いため、丸石や鉄がネットワークに入るとこのストレージバスに格納され、ネットワークから取り出すときも*ここ以外*からではなく常にこのバスから引き出されるため、丸石と鉄はこのセルへ“マイグレート”します。
  </BoxAnnotation>

  <BoxAnnotation color="#33dddd" min="11 0 5" max="12 1 6" thickness="0.05">
    汎用ストレージ。ここでは16kセルで満たされたドライブを使用しています。これらのセルはパーティション分割されていません。ドライブの優先度は中立（ここでは0）に設定されているため、ネットワークにアイテムが入るとまず専用の大量ストレージやローカルストレージに格納され、取り出すときはここから優先的に引き出されるため、専用ストレージを持つアイテムは自然と汎用ストレージから“マイグレート”します。
  </BoxAnnotation>

  <BoxAnnotation color="#88ff88" min="11 0 8" max="12 1 9" thickness="0.05">
    このIOポートは、ネットワークを整理された状態に保つ上で重要な役割を果たします。ストレージ優先度ではアイテムを*能動的に*移動させないため、汎用ストレージで使用しているセルは定期的にIOポートを通じて“シャッフル”し、専用ストレージに移すべきアイテムを実際に専用ストレージへ移動させる必要があります。これによりストレージを“デフラグ”し、アイテムが複数箇所に分散して保管されないようにします。
  </BoxAnnotation>

  <BoxAnnotation color="#dd3333" min="14 0 11" max="15 1 12" thickness="0.05">
    モブファーム向けローカルストレージ。このドライブは骨や矢など保持したいドロップアイテムにパーティション設定されたセルを搭載しています。ドライブ自体に優先度は設定されていません。優先度を決定するのはメインネットワークからサブネットにアクセスするストレージバスだからです。セルには均等分配カードとオーバーフロー破壊カードが装着されています。
  </BoxAnnotation>

  <BoxAnnotation color="#dd3333" min="14 1 10" max="15 2.3 11" thickness="0.05">
    モブファーム向けローカルストレージ。このストレージバスとインターフェイスの組み合わせにより、メインネットワークがこのサブネットのストレージにアクセスできます。ストレージバスには高い優先度が設定され、サブネット内のセルに保管されているアイテムにフィルタリングされています。

    重要: サブネット上のゴミ箱設定のため、このストレージバスには必ずフィルタを設定してください。そうしないとネットワークに入る*すべてのアイテム、流体など*が破棄されてしまいます！
  </BoxAnnotation>

  <BoxAnnotation color="#dd3333" min="14 0 9" max="15 1.3 10" thickness="0.05">
    モブファーム向けローカルストレージ。このストレージバスは物質凝縮器上に設置され、ドライブより低い優先度に設定されています。これにより、ドライブのセルに収まりきらないモブドロップはここにオーバーフローして破棄されます。これは、ほとんど壊れた弓のようなランダムな不要アイテムでサブネットが詰まるのを防ぐ上で重要です。
  </BoxAnnotation>

  <BoxAnnotation color="#dd33dd" min="8 1 11.7" max="9 2.3 13" thickness="0.05">
    メロンファーム向けローカルストレージ。このセットアップは、先述のサータスクォーツファーム例で使用した方法と類似しています。サブネット上のストレージバスが農作物（メロン）をバレルに投入し、メインネットワーク上の別のストレージバス（メロンのスライスにフィルタ設定され、高い優先度が付与されている）が、メインネットワークに農作物へのアクセスを提供します。
  </BoxAnnotation>

  <IsometricCamera yaw="270" pitch="30" />
</GameScene>
