---
navigation:
  parent: example-setups/example-setups-index.md
  title: 半自動サータスクォーツファーム
  icon: certus_quartz_crystal
  position: 115
---

# 半自動サータスクォーツファーム

残念ながら、[シンプルサータスクォーツファーム](simple-certus-farm.md)は完全自動化には<ItemLink id="flawless_budding_quartz" />が必要です。これは[空間入出力](../ae2-mechanics/spatial-io.md)を使うか、[隕石](../ae2-mechanics/meteorites.md)に設置しなければなりません。

しかし、AE2はブロックの設置と破壊が可能なので、ファームに芽生えたサータスクォーツの交換を自動化させることもできます。（定期的に不完全な芽生えたサータスクォーツを入力用樽に投入し、使用済み芽生えたサータスクォーツの樽からクォーツブロックを取り出す必要があります）

完全自動化するには[上級サータスクォーツファーム](advanced-certus-farm.md)をご覧ください。

このファームは[シンプルサータスクォーツファーム](simple-certus-farm.md)より少し複雑で、実際には3つの構成をまとめたものです。

推定速度については[サータスクォーツの成長](../ae2-mechanics/certus-growth.md)を参照してください。

**これは複雑な構造で、要素が隠れている部分もあります。あらゆる角度からパンして確認してください**

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/semiauto_certus_farm.snbt" />

  <BoxAnnotation color="#ddaaaa" min="3.7 2 1" max="4 3 2">
        (1) ME殲滅プレーン #1：GUIを設定できませんが、幸運（Fortune）を付与できます。
  </BoxAnnotation>

  <BoxAnnotation color="#ddaaaa" min="2 2 1" max="2.3 3 2">
        (2) MEストレージバス #1：<ItemImage id="certus_quartz_crystal" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 2.5 1.5" color="#ff0000">
    クラスター破壊サブネット
  </DiamondAnnotation>

  <BoxAnnotation color="#aaddaa" min="3.7 1 1" max="4 2 2">
        (3) ME殲滅プレーン #2：GUIを設定できませんが、シルクタッチ（Silk Touch）を付与する必要があります。
  </BoxAnnotation>

  <BoxAnnotation color="#aaddaa" min="2 1 1" max="2.3 2 2">
        (4) MEストレージバス #2：<BlockImage id="quartz_block" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 1.5 1.5" color="#00ff00">
    サータスクォーツブロック破壊サブネット
  </DiamondAnnotation>

  <BoxAnnotation color="#ffddaa" min="4 0.7 1" max="5 1 2">
        (5) MEフォーメーションプレーン：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#ffddaa" min="2 0 1" max="2.3 1 2">
        (6) MEインポートバス：デフォルト設定のままです。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 0.5 1.5" color="#ddcc00">
    芽生えたブロック配置サブネット
  </DiamondAnnotation>

  <BoxAnnotation color="#aaaadd" min="0.7 2 1" max="1 3 2">
        (7) MEストレージバス #3：<ItemImage id="certus_quartz_crystal" scale="2" />をフィルターに設定しており、メインストレージより優先度を高く設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="1.5 0.5 1.5" color="#00ff00">
        不完全な芽生えたサータスクォーツを手動で投入してください。<BlockImage id="flawed_budding_quartz" scale="2" />
  </DiamondAnnotation>

  <DiamondAnnotation pos="1.5 1.5 1.5" color="#00ff00">
        使用済み芽生えたサータスクォーツのクォーツブロックを手動で抽出してください。<BlockImage id="quartz_block" scale="2" />
  </DiamondAnnotation>

  <DiamondAnnotation pos="0.5 0.5 0" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="165" pitch="5" />
</GameScene>

## 設定

### クラスター破壊サブネット

* 最初の <ItemLink id="annihilation_plane" />(1) はGUIを設定できませんが、幸運（Fortune）を付与できます。  
* 最初の <ItemLink id="storage_bus" />(2) は <ItemLink id="certus_quartz_crystal" /> をフィルターに設定しています。  

### サータスクォーツブロック破壊サブネット

* 2番目の <ItemLink id="annihilation_plane" />(3) はGUIを設定できませんが、シルクタッチ（Silk Touch）を付与する必要があります。  
* 2番目の <ItemLink id="storage_bus" />(4) は <BlockImage id="quartz_block" /> をフィルターに設定しています。  

### 芽生えたブロック配置サブネット

* <ItemLink id="formation_plane" />(5) はデフォルト設定のままです。  
* <ItemLink id="import_bus" />(6) はデフォルト設定のままです。  

### メインネットワーク上

* 3番目の <ItemLink id="storage_bus" />(7) は <ItemLink id="certus_quartz_crystal" /> をフィルターに設定し、[優先度](../ae2-mechanics/import-export-storage.md#storage-priority)をメインストレージより高く設定しています。  

## 仕組み

### クラスター破壊サブネット

1. <ItemLink id="annihilation_plane" /> は前方のクォーツクラスターを破壊しようとしますが、サブネット上で唯一のストレージである <ItemLink id="storage_bus" /> が <ItemLink id="certus_quartz_crystal" /> にフィルター設定されているため、<ItemLink id="quartz_cluster" /> のみを破壊できます。  
2. <ItemLink id="storage_bus" /> は樽にサータスクォーツクリスタルを保管します。  

### サータスクォーツブロック破壊サブネット

1. <ItemLink id="annihilation_plane" /> は前方のブロックを破壊しようとしますが、唯一のストレージである <ItemLink id="storage_bus" /> が <BlockImage id="quartz_block" /> をフィルター設定しているため、<ItemLink id="quartz_block" /> のみを破壊できます。プレーンにはシルクタッチを付与しておく必要があり、これにより芽生えたブロックが破壊時に劣化せず、誤って未成熟のブロックを破壊しません。  
2. <ItemLink id="storage_bus" /> は劣化した芽生えたサータスクォーツブロックを使用済み芽生えた樽に保管します。その後、<ItemLink id="charged_certus_quartz_crystal" /> を使って手動で水中投入し、再利用可能な状態に戻す必要があります。  

### 芽生えたブロック配置サブネット

1. <ItemLink id="import_bus" /> は入力用樽から芽生えたサータスクォーツをインポートします。  
2. サブネット上で唯一のストレージである <ItemLink id="formation_plane" /> が芽生えたブロックを設置します。  

### メインネットワーク上

* <ItemLink id="storage_bus" /> は樽内のすべてのサータスクォーツクリスタルへのアクセスをメインネットワーク（および[チャージャー自動化](charger-automation.md)）に提供します。優先度を[高](../ae2-mechanics/import-export-storage.md#storage-priority)に設定しているため、サータスクォーツクリスタルはメインストレージではなく樽に優先的に戻されます。  
