---
navigation:
  parent: example-setups/example-setups-index.md
  title: 自動制御丸石発生機
  icon: minecraft:cobblestone
---

# 自動制御丸石発生機

丸石発生機の自動化は簡単です。標準のバニラ手動丸石発生装置に<ItemLink id="annihilation_plane" />を向けるだけでよいです。しかし、このままではしばらくするとネットワークが丸石で満杯になってしまうため、一定の制御が必要になります。

殲滅プレーンの動作（<ItemLink id="import_bus" />のように機能する）により、レベルエミッターを<ItemLink id="export_bus" />に向けレッドストーンカードを挿入しただけでは対応できません（ストレージを介さずに直接インポート→エクスポートできないため）。もう少し迂回した構成が必要です。

<ItemLink id="toggle_bus" />はレッドストーン信号でネットワークの一部を接続・切断できますが、動作ごとにネットワーク全体を再起動させてしまいます。簡易的な回避策として、トグルバスを[サブネットワーク](../ae2-mechanics/subnetworks.md)上に配置し、サブネットワークのみを再起動させるようにします。

サブネットワークには、<ItemLink id="annihilation_plane" />と<ItemLink id="storage_bus" />を内蔵し、メインネットワーク上の<ItemLink id="interface" />へアイテムを押し出す構成にします。トグルバスが<ItemLink id="quartz_fiber" />の電力供給を接続・遮断し、プレーンへの電力を制御します。

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/regulated_cobble_gen.snbt" />

  <BoxAnnotation color="#dddddd" min="3 2 2" max="7 2.3 3">
        (1) 殲滅プレーン：GUIはなく設定できませんが、効率強化（Efficiency）や耐久力（Unbreaking）を付与して消費電力を抑えられます。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 2 2" max="2.3 3 3">
        (2) ストレージバス：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 2.3 2" max="2.7 2.7 2.3">
        (3) トグルバス：トグルバスは**サブネットワーク側**（メインネットワークではなく）に設置することが非常に重要です。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 3 2.3" max="2.7 3.3 2.7">
        (4) レベルエミッター：丸石と希望の数量で設定し、「下限を下回ったときに信号を出力」に設定します。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 3" max="2 3 2">
        (5) インターフェース：デフォルト設定のままです。
  </BoxAnnotation>

<DiamondAnnotation pos="0 2.5 1.5" color="#00ff00">
        メインネットワークへ
</DiamondAnnotation>

<DiamondAnnotation pos="5 1.5 3.5" color="#00ff00">
        水で満たした階段ブロックを設置し、水流が溶岩と接触して黒曜石を生成しないようにします。
</DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="annihilation_plane" />(1) はGUIを持たず設定できませんが、効率強化 (Efficiency) や耐久力 (Unbreaking) を付与して消費電力を抑えられます。  
* <ItemLink id="storage_bus" />(2) はデフォルト設定のままです。  
* <ItemLink id="toggle_bus" />(3) はクォーツファイバーのサブネットワーク側に設置し、メインネットワーク側に設置しないでください。そうしないとトグル時にメインネットワークが毎回再起動します。  
* <ItemLink id="level_emitter" />(4) は希望するアイテムと数量で設定し、「下限を下回ったときに信号を出力」に設定します。  
* <ItemLink id="interface" />(5) はデフォルト設定のままです。  

## 仕組み

1. 丸石生成装置が丸石を生成します。  
2. <ItemLink id="annihilation_plane" />が丸石を破壊します。  
3. <ItemLink id="storage_bus" />が破壊された丸石を<ItemLink id="interface" />に保管し、メインネットワークへ送ります。  
4. メインネットワーク内の丸石数が設定値を超えると、<ItemLink id="level_emitter" />が信号の出力を停止し、<ItemLink id="toggle_bus" />がオフになります。  
5. これによりサブネットワークへの電力供給が遮断され、殲滅プレーンが動作を停止します。  
