---
navigation:
  parent: example-setups/example-setups-index.md
  title: 鉱石幸運化の自動化
  icon: minecraft:raw_iron
---

# 鉱石幸運化の自動化

<ItemLink id="annihilation_plane" /> は、幸運（Fortune）を含むあらゆるツルハシのエンチャントを付与できるため、これを活用して<ItemLink id="formation_plane" />と<ItemLink id="annihilation_plane" />を組み合わせ、鉱石を高速で設置・破壊する構成が考えられます。

<ItemLink id="import_bus" /> は「加速」して最大速度に達するまでに数秒かかるため、最初は遅く感じるかもしれませんが、すぐに全速力になります。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/ore_fortuner.snbt" />

  <BoxAnnotation color="#dddddd" min="2.7 0 2" max="3 1 3">
        (1) インポートバス：<ItemImage id="speed_card" scale="2" /> を数枚挿入しています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 0 2" max="2 1 2.3">
        (2) フォーメーションプレーン：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 0 0.7" max="2 1 1">
        (3) 殲滅プレーン：GUIの設定はできませんが、幸運のエンチャントが付与されています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.7 0 0" max="3 1 1">
        (4) ストレージバス：デフォルト設定のままです。
  </BoxAnnotation>

  <DiamondAnnotation pos="3.5 0.5 2.5" color="#00ff00">
        インプット
  </DiamondAnnotation>

  <DiamondAnnotation pos="3.5 0.5 0.5" color="#00ff00">
        アウトプット
  </DiamondAnnotation>

  <DiamondAnnotation pos="4 0.5 1.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="import_bus" />(1) には複数の <ItemLink id="speed_card" /> を挿入します。フォーメーションプレーンの数が多いほど、取り込むアイテムも増えるため、速度アップが重要です。
* <ItemLink id="formation_plane" />(2) はデフォルト設定のままで使用します。
* <ItemLink id="annihilation_plane" />(3) はGUIを持ちませんが、幸運エンチャントが付与されています。
* <ItemLink id="storage_bus" />(4) はデフォルト設定のままで使用します。

## 仕組み

1. 緑色のサブネットにある <ItemLink id="import_bus" /> が、1つ目の樽から鉱石ブロックを[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)へインポートします。  
2. 緑色のサブネットにおける唯一のストレージである <ItemLink id="formation_plane" /> が、インポートされたブロックを設置します。  
3. オレンジ色のサブネットにある <ItemLink id="annihilation_plane" /> が、設置された鉱石ブロックを破壊し、幸運の効果を適用します。  
4. オレンジ色のサブネットにある <ItemLink id="storage_bus" /> が、破壊された鉱石のドロップを2つ目の樽へ保存します。  
