---
navigation:
  parent: example-setups/example-setups-index.md
  title: レベルエミッターによる自動補充
  icon: level_emitter
---

# レベルエミッターによる自動補充

「特定のアイテムを常に在庫しておき、不足したら自動でクラフトするには？」と考える方もいるでしょう。

その解決策のひとつが、<ItemLink id="export_bus" />、<ItemLink id="level_emitter" />、<ItemLink id="crafting_card" />を組み合わせて、ネットワークの[自動クラフティング](../ae2-mechanics/autocrafting.md)からアイテムを自動的に要求する方法です。この構成は、単一のアイテムを大量に維持したい場合に向いています。

レベルエミッターとレッドストーンカードを使わず、継続的にクラフトさせることも可能です。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/level_emitter_autostocking.snbt" />

  <BoxAnnotation color="#dddddd" min="1 1 0" max="2 1.3 1">
        (1) エクスポートバス：目的のアイテムをフィルターに設定。<ItemImage id="redstone_card" scale="2" /> と <ItemImage id="crafting_card" scale="2" /> を挿入。  
        レッドストーンモードは「信号があるとき動作」、クラフト動作は「在庫を使わずにクラフト」に設定。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0.7 1 0" max="1 2 1">
        (2) レベルエミッター：目的のアイテムと在庫数を設定し、「在庫が下回ったときに出力」に設定。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 0" max="2 1 1">
        (3) インターフェース：デフォルト設定のままです。
  </BoxAnnotation>

  <DiamondAnnotation pos="4 0.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="export_bus" />(1) は目的のアイテムをフィルターに設定し、<ItemLink id="redstone_card" />と<ItemLink id="crafting_card" />を挿入します。  
  「レッドストーンモード」は「信号があるとき動作」、「クラフト動作」は「在庫を使わずにクラフト」に設定します。
* <ItemLink id="level_emitter" />(2) は目的のアイテムと希望する在庫数を設定し、「在庫が下回ったときに出力」に設定します。
* <ItemLink id="interface" />(3) はデフォルト設定のまま使用します。

## 仕組み

1. [ネットワークストレージ](../ae2-mechanics/import-export-storage.md)内のアイテム数が、<ItemLink id="level_emitter" />で指定した数を下回ると、レッドストーン信号を出力します。
2. この信号を受けて、<ItemLink id="export_bus" />が動作します。<ItemLink id="crafting_card" />が挿入されており、「在庫を使わずにクラフト」に設定されているため、ネットワークの[自動クラフティング](../ae2-mechanics/autocrafting.md)によってアイテムが作成され、エクスポートバスから出力されます。
3. アイテムが <ItemLink id="interface" /> に入力されると、インターフェースはそのアイテムをネットワークストレージへと戻します（内部在庫に設定がないため、自動で転送されます）。
