---
navigation:
  parent: example-setups/example-setups-index.md
  title: インターフェース自動補充
  icon: interface
---

# インターフェース自動補充

「特定のアイテムを常に一定数だけ在庫しておき、不足したら自動でクラフトするには？」という疑問を持つ方もいるでしょう。

その解決策のひとつが、<ItemLink id="interface" />と<ItemLink id="crafting_card" />を組み合わせてネットワークの[自動クラフティング](../ae2-mechanics/autocrafting.md)から自動的にアイテムを要求する方法です。この構成は、少量ずつさまざまなアイテムを在庫したい場合に適しています。

このデモ構成は横幅を抑えるために簡略化されていますが、通常の[ケーブル](../items-blocks-machines/cables.md)が持つ8[チャンネル](../ae2-mechanics/channels.md)を最大限活用するには、<ItemLink id="interface" />4つと<ItemLink id="storage_bus" />4つを組み合わせるのが最適です。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_autostocking.snbt" />

  <BoxAnnotation color="#dddddd" min="0 0 0" max="2 1 1">
        (1) インターフェース：それぞれに保持したいアイテムを設定し、<ItemImage id="crafting_card" scale="2" />を挿入しています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 0" max="2 1.3 1">
        (2) ストレージバス：「入出力モード」は「抽出のみ（Extract Only）」に設定します。
  </BoxAnnotation>

  <DiamondAnnotation pos="4 0.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="interface" />(1) は、保持したいアイテムをスロットに設定し、上部のレンチアイコンをクリックして保持数を指定します。<ItemLink id="crafting_card" />を挿入してください。
* <ItemLink id="storage_bus" />(2) は「入出力モード」を「抽出のみ（Extract Only）」に設定します。

## 仕組み

1. <ItemLink id="interface" /> に設定されたアイテムが[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)から十分に取得できない場合（かつ<ItemLink id="crafting_card" />が装着されている場合）、そのアイテムのクラフトをネットワークの[自動クラフティング](../ae2-mechanics/autocrafting.md)に要求します。
2. <ItemLink id="storage_bus" /> により、ネットワークはインターフェース内のアイテムにアクセス可能になります。
