---
navigation:
  parent: example-setups/example-setups-index.md
  title: セル排出・充填機
  icon: io_port
---

# セル排出・充填機

「ストレージセルの中身をチェストやドロワー配列、バックパックに素早く排出したり、その逆にセルに充填したりするにはどうすればよいでしょうか？」と考えるかもしれません。

その答えは <ItemLink id="io_port" /> を使用し、サブネットを構成してアイテムの投入・抽出先を制限することです。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/cell_dumper_filler.snbt" />

  <BoxAnnotation color="#dddddd" min="1 1 0" max="2 2 1">
        (1) ME IOポート：GUI中央の矢印ボタンで「ネットワークへ転送」モードまたは「ストレージセルへ転送」モードに設定できる。加速カードを3枚搭載している。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 0.7 0" max="1 1 1">
        (2) MEストレージバス：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="0 1 0" max="1 2 1">
        ここに排出または充填したいものを置いてください。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 0.35 0.35" max="2.3 0.65 0.65">
        クォーツファイバー：エネルギー源が別のネットワークの場合のみ必要です。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 0.5 0.5" color="#00ff00">
        別のネットワークやエネルギーアクセプターなど、任意のエネルギー源へ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* GUI中央の矢印ボタンを使って <ItemLink id="io_port" />(1) を「ネットワークへ転送」モードまたは「ストレージセルへ転送」モードに設定できる。加速カードを3枚搭載している。  
* <ItemLink id="storage_bus" />(2) をデフォルト設定のままにしておく。  

## 仕組み

### 「ネットワークへ転送」モードの場合

1. <ItemLink id="io_port" /> が挿入された[ストレージセル](../items-blocks-machines/storage_cells.md)の中身を[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)に排出しようとします。  
2. サブネット上で唯一のストレージは <ItemLink id="storage_bus" /> で、ここに置いたアイテムや流体などを保管します。  
* <ItemLink id="energy_cell" /> は[エネルギー](../ae2-mechanics/energy.md)を十分に蓄え、1ゲームティックあたり大量のアイテムを転送してもネットワークの電力が不足しないようにします。  

### 「ストレージセルへ転送」モードの場合

1. <ItemLink id="io_port" /> が[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)の中身を挿入された[ストレージセル](../items-blocks-machines/storage_cells.md)に排出しようとします。  
2. サブネット上で唯一のストレージは <ItemLink id="storage_bus" /> で、ここに置いたアイテムや流体などを取り出します。  
* <ItemLink id="energy_cell" /> は[エネルギー](../ae2-mechanics/energy.md)を十分に蓄え、1ゲームティックあたり大量のアイテムを転送してもネットワークの電力が不足しないようにします。  
