---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: バイブレーションチャンバー
  icon: vibration_chamber
  position: 110
categories:
- network infrastructure
item_ids:
- ae2:vibration_chamber
---

# バイブレーションチャンバー

<BlockImage id="vibration_chamber" p:active="true" scale="8" />

ネットワークに[エネルギー](../ae2-mechanics/energy.md)を供給する主な方法は<ItemLink id="energy_acceptor" />ですが、バイブレーションチャンバーはAEを直接、小〜中程度の量で生成できます。

デフォルト設定（[アップグレード](upgrade_cards.md)なし、設定変更なし）では、40 AE/tを生成します。

ネットワークの[エネルギー](../ae2-mechanics/energy.md)ストレージが満タンになると、バイブレーションチャンバーは燃料を節約するために出力を抑えますが、完全には停止しません。

## 設定

* バイブレーションチャンバーでは、エネルギー表示をAEまたはE/FEに切り替えるグローバル設定にアクセスできます。

## アップグレード

バイブレーションチャンバーは以下の[アップグレード](upgrade_cards.md)に対応しています：

* <ItemLink id="energy_card" />：効率を+50%向上させます（最大+150%、つまり基礎効率の250%まで）。
* <ItemLink id="speed_card" />：燃焼速度を+50%向上させます（最大+150%、つまり出力250%まで）。

## コンフィグ

バイブレーションチャンバーの動作特性は、`.minecraft`ディレクトリ内の`config/ae2/common.json`で編集できます。

* `baseEnergyPerFuelTick`：アップグレードなしの基本効率を設定します。
* `minEnergyPerGameTick`：生成される最小エネルギー量を設定します（ネットワークがエネルギーを必要としなくても、少量の燃料は常に消費されます）。
* `maxEnergyPerGameTick`：アップグレードなしの最大出力（および速度）を設定します。

## レシピ

<RecipeFor id="vibration_chamber" />
