---
navigation:
  title: はじめに (1.20+)
  position: 10
---

<div class="notification is-info">
  以下の情報は、Minecraft 1.20以降のApplied Energistics 2にのみ適用されます。
</div>

# はじめに

## 初期材料の入手

<GameScene zoom="4" background="transparent">
  <ImportStructure src="assets/assemblies/meteor_interior.snbt" />
</GameScene>

Applied Energistics 2を始めるには、まず[隕石](ae2-mechanics/meteorites.md)を探す必要があります。隕石は比較的よく見つかり、地形に大きな穴を残すため、探索中に遭遇した方も多いでしょう。もし見つからない場合は、<ItemLink id="meteorite_compass" />を作成すると、最寄りの<ItemLink id="mysterious_cube" />の方向を指し示してくれます。

隕石を見つけたら、その中心に向かって採掘してください。そこにはCertus Quartzのクラスターやバッド、各種[芽生えたCertusブロック](items-blocks-machines/budding_certus.md)、そして中央のミステリアスキューブが設置されています。

Certus Quartzのクラスターとブロックを採掘し、芽生えたCertusブロックもシ Silk Touchなしで採掘できますが、ティアが一段階劣化します。  
完璧な（Flawless）芽生えたCertusブロックは、Silk Touchがあっても「欠陥のある（Flawed）」芽生えたブロックに変化するため、壊さないよう注意してください。

また、中央のミステリアスキューブを採掘すると、インスクライバー用の4種類のプレスを入手できます。

## Certus Quartzの栽培

<GameScene zoom="4" background="transparent">
  <ImportStructure src="assets/assemblies/budding_certus_1.snbt" />
</GameScene>

Certus Quartzのバッドは、[芽生えたCertusブロック](items-blocks-machines/budding_certus.md)からアメジストのように成長します。成長途中のバッドを壊すと、Fortuneの影響を受けずに<ItemLink id="certus_quartz_dust" />を1つドロップします。完全に成長したクラスターを壊すと<ItemLink id="certus_quartz_crystal" />を4つドロップし、Fortuneで数が増加します。

芽生えたCertusブロックには4つのティアがあります：Flawless、Flawed、Chipped、Damaged。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="assets/assemblies/budding_blocks.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

バッドが成長するたびに、芽生えたブロックが1ティア劣化する可能性があり、最終的に通常のCertus Quartzブロックになります。芽生えたブロックやCertus Quartzブロックを水中に<ItemLink id="charged_certus_quartz_crystal" />と一緒に投げ込むと、修復（および新たな芽生えたブロックの生成）が可能です。

<RecipeFor id="damaged_budding_quartz" />

Flawless芽生えたCertusブロックは劣化せず、無限にCertusを生成します。ただし、クラフトやSilk Touchでも移動できないため、[空間ストレージ](ae2-mechanics/spatial-io.md)などを使って移動してください。

単体では芽生えたバッドは非常にゆっくり成長しますが、<ItemLink id="growth_accelerator" />を隣接させると成長が大幅に加速します。まずはこれらを最優先で用意しましょう。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="assets/assemblies/budding_certus_2.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

もしエネルギーアクセプターや振動チャンバーをまだ作れない場合は、<ItemLink id="crank" />を成長アクセラレーターの端に取り付けて回すこともできます。

Certus Quartzの自動収穫については、[簡易Certusファームの例](example-setups/simple-certus-farm.md)をご覧ください。

## Fluixについての補足

もうひとつ必要になる材料がFluixです。成長アクセラレーターを作成する際に既に触れている通り、FluixはチャージドCertus、レッドストーン、ネザー水晶を水中に投げ込むことで生成されます。自動化は「読者への演習」として残します。

<ItemLink id="charger" />はチャージドCertus Quartzクリスタルを生成するのに必要です。まだ作っていない場合は先に作成してください。

## プロセッサの刻印

隕石のミステリアスキューブから入手した4種類のプレスを、<ItemLink id="inscriber" />にセットしてプロセッサを作成します。

<ItemGrid>
  <ItemIcon id="silicon_press" />
  <ItemIcon id="logic_processor_press" />
  <ItemIcon id="calculation_processor_press" />
  <ItemIcon id="engineering_processor_press" />
</ItemGrid>

インスクライバーはバニラのかまどのように「サイド設定」が可能です。上下からの投入で上下スロットに、側面や背面からの投入で中央スロットに入り、側面・背面から結果を取り出せます。

ホッパーなどで自動化しやすいよう、<ItemLink id="certus_quartz_wrench" />で回転させて向きを調整できます。

次のステップに備え、各種プロセッサをいくつか作成してください。プロセッサ生産の自動化は「演習」として[こちら](example-setups/processor-automation.md)をご覧ください。

## マターエナジーテック：MEネットワークとストレージ

### MEストレージとは？

ME（エムイー）は “Matter Energy” の略称で、Applied Energistics 2の中核です。多ブロックチェストをさらに発展させたようなシステムで、狭い場所に大量のストレージを実現し、複数のアクセスターミナルから同時にアクセスできます。従来のMinecraftストレージとはまったく異なるため、少し発想を変えて取り組む必要があります。

### 始めるにあたって知っておくべきこと

まず、MEは[ストレージセル](items-blocks-machines/storage_cells.md)と呼ばれるアイテム内にアイテムを保存します。ストレージセルは5つのティアがあり、容量が段階的に増加します。セルを使うには、<ItemLink id="chest" />または<ItemLink id="drive" />にセットする必要があります。

<ItemLink id="chest" />はセルをセットすると即座に中身を表示し、通常のチェストのようにアイテムを出し入れできます。ただし、実際のデータはストレージセル内に保存されています。

<ItemLink id="chest" />は用途が限定的で実用性も限られます。本格的にAE2を活用するには、[MEネットワーク](ae2-mechanics/me-network-connections.md)を構築しましょう。

## あなたの最初のMEシステム

基本的な材料と機械が揃ったら、最初のME（Matter Energy）システムを作成します。自動化や物流は使わず、シンプルに検索可能なストレージを構築します。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="assets/assemblies/tiny_me_system.snbt" />
</GameScene>

*材料リスト：*  
* 1× <ItemLink id="drive" />  
* 1× <ItemLink id="terminal" /> または <ItemLink id="crafting_terminal" />  
* 1× <ItemLink id="energy_acceptor" />  
* 数本の[ケーブル](items-blocks-machines/cables.md)（ガラス、カバー、スマートケーブルなど。ただしデンスは除く）  
* 数枚の[ストレージセル](items-blocks-machines/storage_cells.md)（4kセル推奨：容量と種類のバランスが良いですが、より高度な[パーティション](items-blocks-machines/cell_workbench.md)は後述）

1. ドライブを設置する。  
2. エネルギーアクセプター（立方体型またはフラット型）をドライブの隣に設置する。  
3. ケーブルやパイプで好みのエネルギー生成装置からアクセプターに電力を供給する。  
4. ドライブ上部（または目線の高さ）にケーブルを設置し、ターミナルまたはクラフティングターミナルを取り付ける。  
5. ドライブにストレージセルをセットする。  
6. 完成！  
7. ターミナルの設定を調整する。  
8. MEの力を実感する。  
9. しかし、このシステムはまだ小規模だと気付く。

### ネットワークの拡張

基本的なストレージとアクセスが整ったら、処理を自動化したくなるでしょう。たとえば、かまどの上部に<ItemLink id="export_bus" />を、下部に<ItemLink id="import_bus" />を設置すると、鉱石投入と生成物回収を自動化できます。

<ItemLink id="export_bus" />はネットワークから外部インベントリへアイテムを出力し、<ItemLink id="import_bus" />は外部インベントリからネットワークへアイテムを取り込みます。

### 制限の克服

ネットワーク上に8台以上の[デバイス](ae2-mechanics/devices.md)を接続すると、チャネル数の管理が必要になります。デフォルトでは8チャネルが上限です。9台目以降は<ItemLink id="controller" />を追加してネットワークを拡張しましょう。[スマートケーブル]を使うと、各チャネルのルーティング状況を可視化できるので、配線が複雑になる序盤は多用してネットワークの動作を把握してください。
