---
navigation:
  parent: example-setups/example-setups-index.md
  title: シンプルサータスクォーツファーム
  icon: certus_quartz_crystal
  position: 110
---

# シンプルサータスクォーツファーム

[サータスクォーツの成長](../ae2-mechanics/certus-growth.md)で述べたように、<ItemLink id="certus_quartz_crystal" />の収穫自動化には<ItemLink id="annihilation_plane" />と<ItemLink id="storage_bus" />を使用します。<ItemLink id="growth_accelerator" />を用いて芽生えたサータスクォーツの成長を大幅に加速し、その後プレーンで完全に成長した<ItemLink id="quartz_cluster" />を破壊します。未成熟の芽生えたサータスクォーツは何もドロップせずに消えるのではなく<ItemLink id="certus_quartz_dust" />をドロップするという不思議なほど幸運な特性を利用してフィルターし、ネットワークは<ItemLink id="certus_quartz_dust" />を受け入れられるため、プレーンは成熟したクラスターのみを破壊します。

このファームは<ItemLink id="flawless_budding_quartz" />を使用すれば完全自動化できますが、不完全、欠けた、または損傷した芽生えたサータスクォーツを使用する場合は、定期的に芽生えたブロックを手動で交換する必要があります。あるいは[半自動サータスクォーツファーム](semiauto-certus-farm.md)や[上級サータスクォーツファーム](advanced-certus-farm.md)で完全自動化することも可能です。

推定速度については[サータスクォーツの成長](../ae2-mechanics/certus-growth.md)を参照してください。

**この構成はシンプルですが、要素が隠れている部分もあるため、あらゆる角度からパンして確認してください**

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/simple_certus_farm.snbt" />

  <BoxAnnotation color="#dddddd" min="3.7 1 1" max="4 2 2">
        (1) 殲滅プレーン：GUIはなく設定できませんが、幸運（Fortune）を付与できます。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 1" max="3.3 2 2">
        (2) ストレージバス #1：<ItemImage id="certus_quartz_crystal" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 .7" max="2 2 1">
        (3) ストレージバス #2：<ItemImage id="certus_quartz_crystal" scale="2" />をフィルターに設定し、メインストレージより優先度を高く設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="1 0.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* 最初の <ItemLink id="annihilation_plane" />(1) はGUIがなく設定できませんが、幸運（Fortune）を付与できます。  
* 最初の <ItemLink id="storage_bus" />(2) は<ItemLink id="certus_quartz_crystal" />をフィルターに設定しています。  
* 2番目の <ItemLink id="storage_bus" />(3) は<ItemLink id="certus_quartz_crystal" />をフィルターに設定し、[優先度](../ae2-mechanics/import-export-storage.md#storage-priority)をメインストレージより高く設定しています。  

## 仕組み

1. <ItemLink id="annihilation_plane" />は前方のクォーツクラスターを破壊しようとしますが、サブネット上で唯一のストレージである<ItemLink id="storage_bus" />が<ItemLink id="certus_quartz_crystal" />にフィルター設定されているため、<ItemLink id="quartz_cluster" />のみを破壊します。  
2. 最初の <ItemLink id="storage_bus" />(2) が樽にサータスクォーツクリスタルを保管します。  
3. 2番目の <ItemLink id="storage_bus" />(3) が樽内のサータスクォーツクリスタルをメインネットワークへ提供します。優先度を高く設定しているため、クリスタルはメインストレージではなく樽に優先的に戻されます。  
