---
navigation:
  parent: example-setups/example-setups-index.md
  title: プロセッサーの自動化
  icon: logic_processor
---

# プロセッサーの自動化

[プロセッサー](../items-blocks-machines/processors.md) を自動化する方法は数多く存在しますが、ここではその一例を紹介します。

この一般的なレイアウトは、フィルター設定可能な任意のアイテムロジスティクスパイプや導管などを使って構築できます。

![プロセスフローダイアグラム](../assets/diagrams/processor_flow_diagram.png)

以下では、AE2 のみを用いて「パイプ」サブネットを活用する方法を詳述します。

<ItemLink id="pattern_provider" /> を使用しているため、これは [自動クラフティング](../ae2-mechanics/autocrafting.md) の設定に統合することを前提としています。単体でプロセッサーを自動化したい場合は、パターンプロバイダーを別のバレルに置き換え、素材を上部のバレルに直接投入してください。

この方法は、<ItemLink id="inscriber" /> が面指定されている場合でも、パイプサブネットが正しい面からアイテムを挿入・抽出するため、旧バージョンの AE2 でも互換性があります。

## パターンエンコードの注意

多くの場合、エンコードすべき [パターン](../items-blocks-machines/patterns.md) は JEI に表示される内容や「+」ボタンで出力されるレシピと一致しません。この例では、JEI は印刷用部品用と最終組み立て用の2つのパターンを出力し、前者には [プレス](../items-blocks-machines/presses.md) が含まれています。しかし、この構成ではプレスは既にインスクライバーにセットされているため、パターンに含めるべきではありません。素材から完成品までを一つのパターンとしてエンコードしてください。

---

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/processor_automation.snbt" />

  <BoxAnnotation color="#dddddd" min="5 1 0" max="6 2 1" thickness=".05">
        (1) パターンプロバイダー：デフォルト設定のまま、対応する処理パターンを登録しています。
        <Row>
            ![ロジックパターン](../assets/diagrams/logic_pattern_small.png)
            ![計算パターン](../assets/diagrams/calculation_pattern_small.png)
            ![エンジニアリングパターン](../assets/diagrams/engineering_pattern_small.png)
        </Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4.7 2 0" max="5 3 1" thickness=".05">
        (2) ストレージバス #1：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 1 0" max="4.3 2 1" thickness=".05">
        (3) エクスポートバス #1：<ItemImage id="silicon" scale="2" />（シリコン）をフィルター、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 4 0" max="4.3 3 1" thickness=".05">
        (4) エクスポートバス #2：<ItemImage id="minecraft:gold_ingot" scale="2" />（金インゴット）をフィルター、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 5 0" max="4.3 4 1" thickness=".05">
        (5) エクスポートバス #3：<ItemImage id="certus_quartz_crystal" scale="2" />（サータスクォーツクリスタル）をフィルター、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 6 0" max="4.3 5 1" thickness=".05">
        (6) エクスポートバス #4：<ItemImage id="minecraft:diamond" scale="2" />（ダイヤモンド）をフィルター、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 3 0" max="2 2 1" thickness=".05">
        (7) エクスポートバス #5：<ItemImage id="minecraft:redstone" scale="2" />（レッドストーンダスト）をフィルター、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 1 0" max="3 2 1" thickness=".05">
        (8) インスクライバー #1：デフォルト設定のまま、<ItemImage id="silicon_press" scale="2" />（シリコンプレス）と<ItemImage id="speed_card" scale="2" />を4枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 3 0" max="3 4 1" thickness=".05">
        (9) インスクライバー #2：デフォルト設定のまま、<ItemImage id="logic_processor_press" scale="2" />（ロジックプレス）と<ItemImage id="speed_card" scale="2" />を4枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 4 0" max="3 5 1" thickness=".05">
        (10) インスクライバー #3：デフォルト設定のまま、<ItemImage id="calculation_processor_press" scale="2" />（計算プレス）と<ItemImage id="speed_card" scale="2" />を4枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 5 0" max="3 6 1" thickness=".05">
        (11) インスクライバー #4：デフォルト設定のまま、<ItemImage id="engineering_processor_press" scale="2" />（エンジニアリングプレス）と<ItemImage id="speed_card" scale="2" />を4枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 2 0" max="1 3 1" thickness=".05">
        (12) インスクライバー #5：デフォルト設定のまま、<ItemImage id="speed_card" scale="2" />を4枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.7 2 0" max="3 1 1" thickness=".05">
        (13) インポートバス #1：デフォルト設定のまま、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.7 4 0" max="3 3 1" thickness=".05">
        (14) インポートバス #2：デフォルト設定のまま、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.7 5 0" max="3 4 1" thickness=".05">
        (15) インポートバス #3：デフォルト設定のまま、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.7 6 0" max="3 5 1" thickness=".05">
        (16) インポートバス #4：デフォルト設定のまま、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 3 0" max="1 3.3 1" thickness=".05">
        (17) ストレージバス #2：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 1.7 0" max="1 2 1" thickness=".05">
        (18) ストレージバス #3：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 0" max="0.7 3 1" thickness=".05">
        (19) インポートバス #5：デフォルト設定のまま、<ItemImage id="speed_card" scale="2" />を2枚搭載。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="5 0.7 0" max="6 1 1" thickness=".05">
        (20) ストレージバス #4：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3.3 2.7 0.3" max="3.7 3 0.7" thickness=".05">
        クォーツファイバーでインスクライバー全台に電力供給（インスクライバーはケーブルとして機能します）。
  </BoxAnnotation>

  <DiamondAnnotation pos="7 1.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="185" pitch="5" />
</GameScene>

## 設定

* <ItemLink id="pattern_provider" />(1) はデフォルト設定で、対応する処理パターンを登録します。パターンにはプレスを含めず、素材から完成プロセッサーへのレシピとしてください。
* <ItemLink id="storage_bus" />(2,17,18,20) はすべてデフォルト設定です。
* <ItemLink id="export_bus" />(3–7) は各素材をフィルターに設定し、<ItemLink id="speed_card" />を2枚ずつ搭載します。
* <ItemLink id="import_bus" />(13–16,19) はすべてデフォルト設定で、<ItemLink id="speed_card" />を2枚ずつ搭載します。
* <ItemLink id="inscriber" />(8–12) はデフォルト設定で、該当プレスをセットし、<ItemLink id="speed_card" />を4枚ずつ搭載します。

## 仕組み

1. <ItemLink id="pattern_provider" /> が素材をバレルへ搬入します。  
2. 最初の[パイプサブネット](pipe-subnet.md)（オレンジ）が、シリコン、レッドストーンダスト、および金インゴット／サータスクォーツクリスタル／ダイヤモンドをバレルから対応する<ItemLink id="inscriber" />へ搬入します。  
3. 最初の4台の<ItemLink id="inscriber" />がそれぞれ<ItemLink id="printed_silicon" />、<ItemLink id="printed_logic_processor" />、<ItemLink id="printed_calculation_processor" />、<ItemLink id="printed_engineering_processor" />を作成します。  
4. 次の2つの[パイプサブネット](pipe-subnet.md)（緑）が、印刷済み部品を5台目のインスクライバーへ搬入します。  
5. 5台目のインスクライバーが最終的な[プロセッサー](../items-blocks-machines/processors.md)を組み立てます。  
6. 最後の[パイプサブネット](pipe-subnet.md)（紫）がプロセッサーをパターンプロバイダーへ返却し、メインネットワークに戻します。  
