---
navigation:
  parent: example-setups/example-setups-index.md
  title: メインネットワークの例
  icon: controller
---

# メインネットワークの例

多くの構成では「メインネットワーク」が参照されています。また、「これらの[デバイス](../ae2-mechanics/devices.md)がどのように組み合わさって機能するシステムになるのか？」という疑問を持つ方もいるかもしれません。以下にその一例を示します。

<GameScene zoom="2.5" interactive={true}>
  <ImportStructure src="../assets/assemblies/small_base_network.snbt" />

  <BoxAnnotation color="#33dd33" min="5 1 10" max="9 7 14" thickness="0.05">
      多数のパターンプロバイダーとアセンブラーを組み合わせることで、クラフティング、ストーンカッター、鍛冶パターン用の広いスペースを確保できます。  
      チェッカーボード状の配置により、各プロバイダーが複数のアセンブラーを並列利用できる上に、コンパクトに収まります。  
      8個単位のグループ構成にするとチャンネルの誤配線も起きにくくなります。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="13 10 12" max="14 11 14" thickness="0.05">
      大きなコントローラーは実は必要ありません。巨大なリングや立方体のようなデザインは主に見た目のためです。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="13 12 13" max="14 13 14" thickness="0.05">
      高速なエネルギー供給と電力変動の安定化のために、優れたネットワークには必ずエネルギーセルが含まれています。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="2 1 10" max="4 4 13" thickness="0.05">
      AE2の電力源には、リアクターやソーラーパネル、ジェネレーターなど、他モッドの発電機を使用するのが一般的です。  
      バイブレーションチャンバーも使えますが、AE2はモッドパック内での連携を前提として設計されているため、拠点全体の発電と統合するのが推奨されます。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="15 1 9" max="16 3 14" thickness="0.05">
      ファサードを使えば、壁の裏に機器類を隠すことができます。
  </BoxAnnotation>
  <BoxAnnotation color="#33dd33" min="15 3 12" max="16 10 14" thickness="0.05">
      ファサードを使えば、壁の裏に機器類を隠すことができます。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="13 9 7" max="14 10 9" thickness="0.05">
      一般的なストレージ用途なら、ドライブベイやセルはそれほど多く必要ありません。  
      4kや16kセルを2〜4ドライブ分用意すれば、ほとんどの場合で十分です。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="13 9 10" max="14 11 11" thickness="0.05">
      バルクストレージ用には、特定アイテム専用にフィルター設定された大型セルを、優先度の高いドライブに入れるのが理想的です。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="10 9 13" max="11.7 13 14" thickness="0.05">
      インターフェースを使った自動補充構成。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="6 10 12" max="9 12 15" thickness="0.05">
      チャージャー自動化構成を複数チャージャーに拡張した形。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="2 10 12" max="5 11 15" thickness="0.05">
      プロセッサー自動化の別構成。1.20以降ではインスクライバーが出力を自動排出できるようになったため可能です。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="3 10 10" max="4 12 11" thickness="0.05">
      プロセッサー自動化の別構成。1.20以降ではインスクライバーが出力を自動排出できるようになったため可能です。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="7.2 9.2 8.2" max="7.8 10 8.8" thickness="0.05">
      無線アクセス端末は、球状に電波が届くため中央に配置するのが理想的です。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="14 1 2" max="16 5 7" thickness="0.05">
      大きなクラフティングジョブ用に1〜2台の大型クラフティングCPUを設置し、それとは別に補助的な小型CPUも用意しておくと便利です。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="5 3 6" max="6 4 7" thickness="0.05">
      サブネットで8台以上の機器に分配する場合などは、独自のコントローラーが必要になることもあります。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="7.3 1 3.3" max="9.7 4 6" thickness="0.05">
      サータスクォーツファーム。
  </BoxAnnotation>

  <BoxAnnotation color="#33dd33" min="10.3 1 2.3" max="12.7 3.7 5" thickness="0.05">
      水中投入自動化。
  </BoxAnnotation>

  <IsometricCamera yaw="135" pitch="15" />
</GameScene>
