---
navigation:
  parent: example-setups/example-setups-index.md
  title: チャージャー自動化
  icon: charger
---

# チャージャー自動化

<ItemLink id="pattern_provider" />を使用しているため、[自動クラフティング](../ae2-mechanics/autocrafting.md)の設定に統合することを想定しています。<ItemLink id="charger" />単体を自動化したい場合は、ホッパーやチェストなどを使用してください。

<ItemLink id="charger" />の自動化は比較的簡単です。<ItemLink id="pattern_provider" />が素材をチャージャーにプッシュし、その後[パイプサブネット](pipe-subnet.md)やその他のアイテムパイプで結果をプロバイダーに戻します。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/charger_automation.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 0" max="2 1 1">
        (1) MEパターンプロバイダー：デフォルト設定のままで、関連する<ItemLink id="processing_pattern" />を登録しています。また、[ケーブル](../items-blocks-machines/cables.md)と同様に振る舞うため、<ItemLink id="charger" />に[エネルギー](../ae2-mechanics/energy.md)を供給します。

        ![チャージャーパターン](../assets/diagrams/charger_pattern_small.png)
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 0" max="1 1.3 1">
        (2) MEインポートバス：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 0" max="2 1.3 1">
        (3) MEストレージバス：デフォルト設定のままです。
  </BoxAnnotation>

  <DiamondAnnotation pos="4 0.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="pattern_provider" />(1) はデフォルト設定のままで、関連する<ItemLink id="processing_pattern" />を登録しています。また、[ケーブル](../items-blocks-machines/cables.md)と同様に振る舞うことで、<ItemLink id="charger" />に[エネルギー](../ae2-mechanics/energy.md)を供給します。
  
    ![チャージャーパターン](../assets/diagrams/charger_pattern.png)

* <ItemLink id="import_bus" />(2) はデフォルト設定のままです。  
* <ItemLink id="storage_bus" />(3) はデフォルト設定のままです。  

## 仕組み

1. <ItemLink id="pattern_provider" /> が素材を <ItemLink id="charger" /> にプッシュします。  
2. <ItemLink id="charger" /> が充電処理を実行します。  
3. <ItemLink id="import_bus" /> がチャージャーから結果を引き出し、[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)に格納しようとします。  
4. サブネット上で唯一のストレージである <ItemLink id="storage_bus" /> が生成されたアイテムをパターンプロバイダーに保管し、メインネットワークに返します。  
