---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: ネットワーク接続
  icon: fluix_glass_cable
---

# ネットワーク接続

## 「ネットワーク」とは何か？

「ネットワーク」とは、[デバイス](../ae2-mechanics/devices.md)を[チャネル](../ae2-mechanics/channels.md)を通じて接続するブロック（[ケーブル](../items-blocks-machines/cables.md)やフルブロックマシン、[デバイス](../ae2-mechanics/devices.md)など）のグループを指します。（<ItemLink id="charger" />、<ItemLink id="interface" />、<ItemLink id="drive" />など）  
技術的には、単一のケーブルもネットワークです。

## デバイス配置について

[デバイス](../ae2-mechanics/devices.md)（<ItemLink id="interface" />がネットワークストレージからプル・プッシュする機能、<ItemLink id="level_emitter" />がネットワークストレージの内容を読み取る機能、<ItemLink id="drive" />がネットワークストレージを提供する機能など）を配置する際、物理的な位置は関係ありません。

**再度強調しますが、デバイスの物理的な位置は関係ありません。**  
重要なのは、デバイスがネットワークに接続されていること（およびどのネットワークに接続されているか）だけです。

## ネットワーク接続

<ItemLink id="network_tool" />を使用すると、ネットワーク上のすべてのコンポーネントを表示できるため、不要なものが含まれていたり、逆に必要なものが表示されていなかったりする場合に問題を特定できます。

たとえば、これは2つの別々のネットワークです。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/2_networks_1.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="1 2 2">
        ネットワーク1
  </BoxAnnotation>

  <BoxAnnotation color="#5CA7CD" min="2 0 0" max="3 2 2">
        ネットワーク2
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

これは、<ItemLink id="quartz_fiber" />が[エネルギー](../ae2-mechanics/energy.md)を共有するだけで
ネットワーク接続を提供しないため、こちらも2つの別々のネットワークです。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/2_networks_2.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="1 2 2">
        ネットワーク1
  </BoxAnnotation>

  <BoxAnnotation color="#5CA7CD" min="1.3 0 0" max="3 2 2">
        ネットワーク2
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

しかし、[quantum bridge](../items-blocks-machines/quantum_bridge.md)はワイヤレスの[密ケーブル](../items-blocks-machines/cables.md#dense-cable)のように
動作するため、これらは1つのネットワークとして扱われます。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/actually_1_network.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="7 3 3">
        全体が1つのネットワーク
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

ケーブルの色は、異なる色同士が接続できないこと以外にネットワーク接続に影響しません。  
すべての色はフルイックス（または「無色」）ケーブルと接続できます。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/actually_1_network_2.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="4 2 2">
        全体が1つのネットワーク
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## サブネットワークにおける接続

[サブネットワーク](../ae2-mechanics/subnetworks.md)は、ネットワーク接続（特に接続されていないこと）を利用して、ある[デバイス](../ae2-mechanics/devices.md)が別のデバイスにアクセスできる範囲を制限します。

サブネットとは、文字通り別のネットワークです。

たとえば、[Automatic Ore Fortuner](../example-setups/ore-fortuner.md)には3つのネットワークがあり、
それぞれ特定の用途に役立ちます。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/ore_fortuner.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 2" max="3 1 3">
        ネットワーク1：パイプサブネットのように機能し、インポートバスが形成プレーン経由で鉱石ブロックを「格納」できる範囲を制限します
  </BoxAnnotation>

  <BoxAnnotation color="#5CA7CD" min="0 0 0" max="3 1 1">
        ネットワーク2：別のパイプサブネットのように機能し、消滅プレーンが生成した鉱石チャンクをメインネットワークではなくバレル内に格納します。また、メインネットワークのチャネルを消費しません
  </BoxAnnotation>

  <BoxAnnotation color="#82CD5C" min="2 0 1" max="4 1 2">
        ネットワーク3：ストレージとクラフトを担うメインネットワークです。主に電力を供給し、サブネットとは接続されていません
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## P2Pにおける接続

[ME P2Pトンネル](../items-blocks-machines/p2p_tunnels.md)の一種では、アイテムや液体、レッドストーン信号の代わりに[チャネル](channels.md)を
搬送します。トンネルを設置しているネットワークと、トンネルが搬送するネットワークは無関係で、同じでも別でもかまいませんが、多くの場合別のネットワークです。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/p2p_channels_network_connection.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="1.98 2 1">
        ネットワーク1：搬送されるネットワーク（通常はメインネットワーク）
  </BoxAnnotation>

  <BoxAnnotation color="#5CA7CD" min="2.02 0 0" max="3.98 1 1">
        ネットワーク2：ME P2Pトンネルを実行するネットワーク（通常はメインネットワークではない）
  </BoxAnnotation>

  <BoxAnnotation color="#915dcd" min="4.02 0 0" max="6 1 1">
        ネットワーク1：搬送されるネットワーク（通常はメインネットワーク）
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 直感に反する接続

この場合、<ItemLink id="pattern_provider" />はフルブロックデバイスとしてケーブルのように振る舞い、<ItemLink id="inscriber" />も同様に動作します。そのため、ネットワーク接続がプロバイダーとインスクライバーを通過しますが、実際は1つのネットワークです。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/pattern_provider_network_connection_1.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="4 2 2">
        全体が1つのネットワーク
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

これを防ぐには、<ItemLink id="certus_quartz_wrench" />でプロバイダーを右クリックして向きを指定し、一方の面からチャネルを通さないようにできます。

<Row gap="40">
<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/pattern_provider_network_connection_2.snbt" />

  <BoxAnnotation color="#915dcd" min="0 0 0" max="1.98 2 2">
        ネットワーク1
  </BoxAnnotation>

  <BoxAnnotation color="#5CA7CD" min="2.02 0 0" max="4 2 2">
        ネットワーク2
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/pattern_provider_directional_connection.snbt" />

  <BoxAnnotation color="#ee3333" min="1 .3 .3" max="1.3 .7 .7">
        ケーブルが接続されないことを確認できます
  </BoxAnnotation>

  <IsometricCamera yaw="255" pitch="30" />
</GameScene>
</Row>

その他、<ItemLink id="import_bus" />、<ItemLink id="storage_bus" />、<ItemLink id="cable_interface" />などの[subpart](../ae2-mechanics/cable-subparts.md)[デバイス](../ae2-mechanics/devices.md)も方向指定によるネットワーク接続を提供しません。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/subpart_no_connection.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>
