---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: サータスクォーツの増殖
  icon: quartz_cluster
---

# サータスクォーツの増殖

## 開始方法ページからの抜粋

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/budding_certus_1.snbt" />
</GameScene>

サータスクォーツの芽は[芽生えたサータスブロック](../items-blocks-machines/budding_certus.md)からアメジストと同様に成長します。成長途中の芽を破壊すると、<ItemLink id="certus_quartz_dust" />を1個ドロップし、フォーチュンの影響を受けません。完全に成長したクラスターを破壊すると、<ItemLink id="certus_quartz_crystal" />が4個ドロップし、フォーチュンで増加します。

芽生えたサータスブロックには4つのティアがあります：完璧（Flawless）、不完全（Flawed）、欠けた（Chipped）、損傷した（Damaged）。最初は[隕石](../ae2-mechanics/meteorites.md)で見つかります。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/budding_blocks.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

芽が次の段階に成長するたびに、芽生えたブロックが一定確率で1ティア劣化し、最終的には通常のサータスクォーツブロックに変わります。芽生えたブロック（またはサータスクォーツブロック）を水中に、<ItemLink id="charged_certus_quartz_crystal" />を1個以上入れて投げ込むと、修復および新規作成が可能です。

<RecipeFor id="damaged_budding_quartz" />

完璧な芽生えたサータスブロックは劣化せず、無限にサータスクォーツを生成します。ただしクラフトやシルクタッチ付きツルハシでの採掘はできません。（[空間ストレージ](../ae2-mechanics/spatial-io.md)でのみ移動可能です）

単体では成長が非常に遅いため、<ItemLink id="growth_accelerator" />を芽生えたブロックの隣に設置すると成長速度が大幅に向上します。まずはこれを優先的に複数作成しましょう。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/budding_certus_2.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

複雑な相互作用により、芽生えたブロックの面が覆われるごとに成長速度が低下し、結果的にアクセラレーターの効果を打ち消します。実測テストによるデータは以下のとおりです：

![Items/min for ratios](../assets/diagrams/certus_farm_speed_chart_1.png)

![common setups](../assets/diagrams/certus_farm_speed_chart_2.png)

Quartzが不足していて<ItemLink id="energy_acceptor" />や<ItemLink id="vibration_chamber" />を作れない場合は、<ItemLink id="crank" />を作成しアクセラレーターの端に取り付けるとよいでしょう。

サータスクォーツの自動収穫は[こちら](../example-setups/simple-certus-farm.md)をご覧ください。
