---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: 自動製造
  icon: pattern_provider
---

# 自動製造

### 本命

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/autocraft_setup_greebles.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

自動製造はAE2の主要機能のひとつです。各サブ素材を必要数分だけ手作業でクラフトして肉体労働に従事する代わりに、MEシステムに任せることができます。アイテムを自動で作成して出力したり、賢い偶発的動作によって特定のアイテム数を常に在庫として維持することも可能です。流体にも対応しており、Mekanismのガスなど追加MODの素材タイプがある場合はそれらも扱えます。非常に優れています。

非常に複雑なトピックなので、覚悟を決めて始めましょう。

自動製造の構成は以下の3要素で成り立ちます：

- クラフトリクエストを送信するもの
- クラフトCPU
- <ItemLink id="pattern_provider" />

流れは以下の通りです：

1. 何かがクラフトリクエストを作成します。これは、ターミナルで自動製造可能なアイテムをクリックする操作だったり、クラフトカードを挿入したExport BusやInterfaceが設定されたアイテムを出力／在庫要求することでも発生します。

*   （**重要：** すでに在庫があるアイテムをリクエストする際は、「ピックブロック」（通常は中ボタンクリック）に割り当てられている操作を使用してください。インベントリソートMODと競合する場合があります）

2. MEシステムがリクエストを満たすために必要な素材と前提クラフト手順を計算し、選択されたクラフトCPUに格納します。

3. 関連する[パターン](../items-blocks-machines/patterns.md)を持つ<ItemLink id="pattern_provider" />が、パターンで指定された素材を隣接するインベントリに送ります。クラフティングテーブルのレシピ（「クラフティングパターン」）の場合は<ItemLink id="molecular_assembler" />に送信されます。クラフト以外のレシピ（「処理パターン」）の場合は、他のブロックや機械、あるいは複雑なレッドストーン制御の構成に送られます。

4. クラフト結果はImport Bus、Interface、またはPattern Providerに結果を戻すなどしてシステムに返されます。**「アイテムがシステムに投入される」というイベントが発生する必要があり、<ItemLink id="storage_bus" />を付けたチェストに直接パイプで送るだけでは動作しません。**

5. もしそのクラフトが別のクラフトの前提であれば、アイテムはクラフトCPUに保存され、次のクラフトで使用されます。

## 再帰レシピ

<ItemImage id="minecraft:netherite_upgrade_smithing_template" scale="4" />

自動製造アルゴリズムが*扱えない*もののひとつが再帰レシピです。例えば、Botaniaのマナプールにレッドストーンを投げ入れることで「レッドストーンダスト1個→2個」を複製するレシピなどです。バニラMinecraftのスミシングテンプレートも同様の例です。ただし、[これらのレシピを処理する方法](../example-setups/recursive-crafting-setup.md)があります。

# パターン

<ItemImage id="crafting_pattern" scale="4" />

パターンは<ItemLink id="pattern_encoding_terminal" />で未記入のパターンから作成します。

パターンには用途に応じたいくつかの種類があります：

* <ItemLink id="crafting_pattern" />はクラフティングテーブルのレシピを記録します。<ItemLink id="molecular_assembler" />に直接挿入して、素材が揃うたびにクラフトさせることもできますが、主な用途は<ItemLink id="pattern_provider" />と隣接させることです。この場合、Pattern Providerは素材とともに該当パターンをアセンブラーに送信します。アセンブラーはクラフト結果を隣接インベントリへ自動排出するため、Pattern Provider上にアセンブラーを配置するだけでクラフティングパターンの自動化が可能です。

***

* <ItemLink id="smithing_table_pattern" />はクラフティングパターンとほぼ同様ですが、スミシングテーブルのレシピを記録します。Pattern ProviderとMolecular Assemblerによって同じように自動化でき、クラフト、スミシング、ストーンカッティングのパターンを同一セットアップで併用できます。

***

* <ItemLink id="stonecutting_pattern" />はクラフティングパターンとほぼ同様ですが、ストーンカッターのレシピを記録します。Pattern ProviderとMolecular Assemblerによって同じように自動化でき、クラフト、スミシング、ストーンカッティングのパターンを同一セットアップで併用できます。

***

* <ItemLink id="processing_pattern" />は自動製造の柔軟性を提供する最も汎用的なパターンです。「Pattern Providerがこれらの素材を隣接インベントリに送れば、近い将来あるいは遠い将来にMEシステムがこれらを受け取る」という指定を行います。これにより、ほとんどあらゆるMOD機械やかまどなどの自動製造が可能になります。素材を送ってから結果を受け取るまでの過程を一切問わないため、非常にユニークな使い方ができます。例えば、複雑な工場生産ラインに素材を送り込んで処理し、無限に素材を生産する施設から他の素材を取り込む、あるいは『Bee Movie』の脚本を印刷する、といったことも可能です。MEシステムはパターンで指定された結果さえ受け取れればよく、素材と結果の関連性すら問われません。例えば「チェリープランク1個＝ネザースター1個」と指定し、チェリープランクを受け取った際にウィザーを自動で討伐する仕組みを組めば動作します。

## より汎用的な「パターン」の形態

<ItemLink id="level_emitter" />にクラフトカードを挿入したものがあります。これを赤石信号を発するように設定するとクラフトが実行されます。この「パターン」は素材を定義せず、素材を考慮しません。「このレベルエミッターから赤石信号を発すると、近い将来あるいは遠い将来にMEシステムがこのアイテムを受け取る」という指定のみ行います。通常は入力素材不要の無限ファームのON/OFF制御や、標準の自動製造が理解できない再帰レシピ（例：「丸石1個＝丸石2個」など複製機構）を扱うために使われます。

# クラフトCPU

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/crafting_cpus.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

クラフトCPUはクラフトリクエスト／ジョブを管理します。複数ステップのクラフトジョブ実行中に中間素材を格納し、ジョブの規模や完了速度に影響します。マルチブロック構造で、少なくとも1つ以上のクラフトストレージを含む直方体である必要があります。

クラフトCPUは以下の要素で構成されます：

* （必須）[クラフトストレージ](../items-blocks-machines/crafting_cpu_multiblock.md)：1k、4k、16k、64k、256kの標準セルサイズが利用可能です。クラフト中の素材と中間素材を格納し、より多くの素材を必要とするジョブでは大きい、または複数のストレージが必要になります。
* （任意）<ItemLink id="crafting_accelerator" />：Pattern Providerからの素材バッチ送出頻度を向上させます。たとえば、6基のMolecular Assemblerに囲まれたPattern Providerが、一度に6基すべてのアセンブラーに素材を送れるようになります。
* （任意）<ItemLink id="crafting_monitor" />：CPUが現在処理中のジョブを表示します。<ItemLink id="color_applicator" />で色を変更できます。
* （任意）<ItemLink id="crafting_unit" />：CPUを直方体にするために空間を埋めるだけのユニットです。

クラフトCPUは1つのリクエスト／ジョブのみ処理するため、計算プロセッサと滑らかな石256個を同時に要求したい場合は、CPUマルチブロックを2つ設置する必要があります。

プレイヤーからのリクエスト、自動化（Export BusやInterface）、またはその両方に対応するよう設定できます。

# パターンプロバイダー

<Row>
<BlockImage id="pattern_provider" scale="4" />

<BlockImage id="pattern_provider" p:push_direction="up" scale="4" />

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/blocks/cable_pattern_provider.snbt" />
</GameScene>
</Row>

<ItemLink id="pattern_provider" />は自動製造システムが世界とやり取りする主要な手段です。[パターン](../items-blocks-machines/patterns.md)で指定された素材を隣接インベントリに送出し、かつそこにアイテムを挿入することでネットワークに取り込めます。多くの場合、<ItemLink id="import_bus" />でマシンの出力をネットワークへ引き込む代わりに、マシンの出力を素材を送った近くのPattern Providerに戻すことでチャンネル数を節約できます。

注意点として、Pattern ProviderはクラフトCPUの[クラフトストレージ](../items-blocks-machines/crafting_cpu_multiblock.md#crafting-storage)から直接素材を送出するため、自身のインベントリに素材を保持しません。したがって、Pattern Providerから直接パイプで出力することはできません。別のインベントリ（たとえばバレル）に送出してから、そこからパイプで取り出す必要があります。

また、Pattern Providerは素材をすべて一度に送出しなければならず、半分だけ送ることはできません。これを利用したテクニックも存在します。

Pattern Providerは[サブネット](../ae2-mechanics/subnetworks.md)上のInterfaceと特別な連携を持ちます。Interfaceの要求スロットが空の状態では、Pattern ProviderはInterfaceを完全にスキップし、そのサブネットの[ストレージ](../ae2-mechanics/import-export-storage.md)に直接送出します。この場合、Interfaceにレシピバッチが入らず、さらにストレージに空きができるまで次のバッチを送出しない点が重要です。

同一パターンを持つ複数のPattern Providerが並列に動作します。

Pattern Providerはバッチをすべての面にラウンドロビンで送ろうとするため、接続されたすべての機械を並列に活用できます。

## バリアント

Pattern Providerにはノーマル、方向指定、フラットの3種類があります。これにより、素材の送出方向、素材の受け取り方向、ネットワーク接続を提供する面が異なります。

* ノーマルPattern Providerはすべての面に素材を送出し、すべての面から素材を受け取り、ほとんどのAE2機械と同様にすべての面でケーブルとしてネットワーク接続を提供します。
* 方向指定Pattern Providerは、ノーマルPattern Providerに<ItemLink id="certus_quartz_wrench" />を使用して方向を変更することで作成できます。選択した面にのみ素材を送出し、すべての面から素材を受け取りますが、選択面にはネットワーク接続を提供しません。サブネットワークを作成したい場合など、ネットワークを接続せずにAE2機械に素材を送るのに便利です。
* フラットPattern Providerは[cable subpart](../ae2-mechanics/cable-subparts.md)で、同じケーブル上に複数設置できるためコンパクトな構成が可能です。方向指定Pattern Providerの選択面と同様に動作し、その面からパターンを提供し、素材を受け取り、ネットワーク接続は提供しません。

Pattern Providerはクラフトグリッドでノーマルとフラットを切り替えできます。

## 設定

Pattern Providerにはさまざまなモードがあります：

* **ブロッキングモード**：マシン内に既に素材がある場合、新しいバッチの送出を停止します。
* **クラフトロック**：さまざまなレッドストーン条件下、または前回のクラフト結果が特定のPattern Providerに挿入されるまでロックできます。
* <ItemLink id="pattern_access_terminal" />でPattern Providerの表示/非表示を切り替えできます。

## 優先度

GUIの右上にあるレンチアイコンをクリックして優先度を設定できます。同一アイテムに対して複数の[パターン](../items-blocks-machines/patterns.md)がある場合、優先度の高いPattern Providerのパターンが使用されます。ただし、ネットワークに高優先度パターンの素材が不足している場合は例外です。

# 分子アセンブラー

<BlockImage id="molecular_assembler" scale="4" />

<ItemLink id="molecular_assembler" />は入力されたアイテムを受け取り、隣接する<ItemLink id="pattern_provider" />や挿入された<ItemLink id="crafting_pattern" />、<ItemLink id="smithing_table_pattern" />、<ItemLink id="stonecutting_pattern" />で定義された操作を実行し、結果を隣接インベントリに送出します。

主な用途は<ItemLink id="pattern_provider" />の隣に設置することです。この場合、Pattern Providerは関連するパターン情報を素材とともに隣接するアセンブラーに送信します。アセンブラーはクラフト結果を隣接インベントリ（すなわちPattern Providerのリターンスロット）に自動排出するため、Pattern Provider上にアセンブラーを配置するだけでクラフティングパターンの自動化が完了します。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/assembler_tower.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>
