---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: ターミナル
  icon: crafting_terminal
  position: 210
categories:
- devices
item_ids:
- ae2:terminal
- ae2:crafting_terminal
- ae2:pattern_encoding_terminal
- ae2:pattern_access_terminal
---

# ターミナル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/terminals.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<ItemLink id="pattern_provider" />や<ItemLink id="import_bus" /> 、 <ItemLink id="storage_bus" />などがAE2ネットワークと世界をつなぐ主な手段であるのに対し、  
**ターミナルはAE2ネットワークと*あなた*をつなぐ主要なインターフェース**です。用途に応じていくつかの種類があります。

ターミナルは、設置された[ケーブル](cables.md)の色を引き継ぎます。

また、[ケーブルサブパーツ](../ae2-mechanics/cable-subparts.md)として扱われます。

## ターミナルの設置

ターミナルは、多くの場合、最初に設置する[サブパーツ](../ae2-mechanics/cable-subparts.md)となるため、  
誤って裏向きに設置してしまうのもよくあるミスです。  
以下は、正しい設置方法と誤った設置方法の例です：

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/terminal_placement.snbt" />
  <IsometricCamera yaw="195" pitch="30" />

  <LineAnnotation color="#ff3333" from="2.5 .5 .5" to="4.5 2.5 .5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="2.5 2.5 .5" to="4.5 .5 .5" alwaysOnTop={true} thickness="0.05"/>

  <LineAnnotation color="#33ff33" from="-.5 2.5 .5" to="1 .5 .5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="1 .5 .5" to="1.5 1 .5" alwaysOnTop={true} thickness="0.05"/>
</GameScene>

同じくターミナルとエネルギーアクセプターを使っていますが、今度はターミナルが正しい向きで設置されており、  
ネットワークにきちんと接続され、しかもよりコンパクトに収まっています。

<a name="terminal-ui"></a>

# ターミナル検索

検索ボックスでは正規表現（Regex）が使用できます。たとえば `"gtceu:.*ore"` と入力すれば、Gregtechのすべての鉱石を検索できます。  
正規表現の習得については、読者の学習にお任せします。

# ターミナル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

基本的なターミナルで、[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)の中身を表示・操作したり、  
[自動クラフト](../ae2-mechanics/autocrafting.md)のリクエストを送ることができます。

## UIについて

基本的なターミナルのUIには、いくつかのセクションがあります。

中央のセクションでは、ネットワークストレージにアクセスできます。アイテムの出し入れが可能です。以下のようなマウス／キー操作があります：

* 左クリックでスタックを取得、右クリックでスタックの半分を取得します。
* アイテムや液体などが[自動クラフト](../ae2-mechanics/autocrafting.md)可能な場合、「ピックブロック」（通常はミドルクリック）を押すと、クラフト数を指定するUIが開きます。`3*64/2`のような数式や、`=32`と入力して在庫が32になるようにクラフトすることもできます。
* Shiftを押しながら表示を見ると、表示中のアイテムの位置が固定され、数量の変化や新しいアイテムの追加によって並び順が変わらなくなります。
* バケツや他の液体容器を持って右クリックすると液体を預けられ、空の容器で液体を左クリックすると液体を取り出せます。

左側のセクションには以下の設定ボタンがあります：

* 名前、MOD名、数量などでソートする
* 保存済みアイテム、クラフト可能アイテム、またはその両方を表示する
* アイテム、液体、またはその両方を表示する
* ソート順を変更する
* 詳細なターミナル設定画面を開く
* ターミナルUIの高さを変更する

右側には<ItemLink id="view_cell" />用のスロットがあります。

中央上部右側のハンマーボタンを押すと、[自動クラフト](../ae2-mechanics/autocrafting.md)の進行状況を確認するステータス画面が開きます。  
ここでは、各[クラフティングCPU](crafting_cpu_multiblock.md)がどの作業を行っているかを見ることができます。

## レシピ

<RecipeFor id="terminal" />

<a name="crafting-terminal-ui"></a>

# クラフティングターミナル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/crafting_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

クラフティングターミナルは、通常のターミナルと同じ機能や設定を持ちつつ、  
中央にクラフトグリッドが追加されたバージョンです。グリッドには[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)から自動で素材が補充されます。  
出力スロットでShiftクリックする際は注意が必要です！

ターミナルは、できるだけ早くクラフティングターミナルにアップグレードするのがおすすめです。

## UIについて

クラフティングターミナルのUIは通常のターミナルと同じですが、中央にクラフトグリッドが追加されています。

さらに、クラフトグリッドの中身をネットワークストレージまたはインベントリに移動するためのボタンが2つ追加されています。

## レシピ

<RecipeFor id="crafting_terminal" />

<a name="pattern-encoding-terminal-ui"></a>

# パターンエンコーディングターミナル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/pattern_encoding_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

パターンエンコーディングターミナルは、通常のターミナルと同じ機能や設定に加えて、  
[パターン](patterns.md)のエンコード用インターフェースが追加されたターミナルです。  
UIはクラフティングターミナルに似ていますが、このクラフトグリッドでは実際のクラフトは行われません。

クラフティングターミナルに加えて、こちらも1台は用意しておくと便利です。

## UIについて

クラフティングターミナルのUIに、[パターン](patterns.md)エンコード用のインターフェースが追加されています。

パターンエンコーディングインターフェースには、以下のセクションがあります：

- <ItemLink id="blank_pattern" />を挿入するスロット
- パターンをエンコードするための大きな矢印ボタン
- エンコード済みパターン用スロット（既存のパターンを編集する場合はここに挿入し、「エンコード」矢印をクリックします）
- パターンの種類を切り替える4つのタブ：
  * クラフト
  * 加工
  * 鍛冶（スミシング）
  * 石切り（ストーンカッティング）

中央のUIは、選択したパターンの種類によって変化します：

### クラフトモードの場合：

- JEI/REIから材料を左クリックまたはドラッグしてレシピを設定できます。右クリックで材料を削除できます。
- 「代用を許可」を有効にすると、どの種類の木材でも棒をクラフトできるようになります。ただし、必要な場合のみに使用するのが推奨されます。
- 「液体代用」を有効にすると、液体入りバケツの代わりにストレージ内の液体を使用可能になります。
- JEI/REIのレシピ画面から直接パターンをエンコードすることも可能です。

### 加工モードの場合：

- JEI/REIから材料を左または右クリック、またはドラッグして、入力と出力を指定します。
- バケツや液体タンクなどの液体コンテナを右クリックすると、中身の液体そのものを材料として指定できます（アイテムではなく液体を使用）。
- スタックを持った状態で左クリックすると全スタック、右クリックで1個を配置できます。  
  既存のスロットを左クリックでスタックごと削除、右クリックで1個ずつ減らせます。  
  「ピックブロック」（通常はミドルクリック）で、特定数のアイテムまたは液体を指定できます。
- 出力スロットには、主出力と副産物を設定できます。副産物を設定しておくと、自動クラフト処理が正確になります。
- 入力／出力スロットはスクロール可能で、最大81種の材料と26種の副産物を指定できます。
- JEI/REIのレシピ画面から直接パターンをエンコードすることも可能です。

### 鍛冶・石切りモードの場合：

- それぞれスミシングテーブルとストーンカッターのUIに似た操作感です。

## レシピ

<RecipeFor id="pattern_encoding_terminal" />

<a name="pattern-access-terminal-ui"></a>

# パターンアクセス・ターミナル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/pattern_access_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

パターンアクセス・ターミナルは、特定の問題を解決するための装置です。  
<ItemLink id="pattern_provider" />や<ItemLink id="molecular_assembler" />が高密度に積み重なっていると、物理的にプロバイダーへパターンを挿入できない場合があります。  
あるいは、単純に[パターン](patterns.md)を挿入するために基地内を移動するのが面倒なこともあるでしょう。  
このターミナルを使えば、ネットワーク上のすべてのパターンプロバイダーに一括してアクセスできます。

## UIについて

このターミナルのUIは、他のターミナルとは異なります。

UIには、ターミナルの高さ設定や、表示するパターンプロバイダーのフィルター設定があります。

ターミナル内の各行は、特定のパターンプロバイダーに対応しています。

プロバイダーの並び順は、接続されているブロックや、<ItemLink id="name_press" />や金床で設定した名前に基づいて整理されます。

## レシピ

<RecipeFor id="pattern_access_terminal" />
