---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: MEストレージバス
  icon: storage_bus
  position: 220
categories:
- devices
item_ids:
- ae2:storage_bus
---

# ストレージバス

<GameScene zoom="8" background="transparent">
<ImportStructure src="../assets/blocks/storage_bus.snbt" />
</GameScene>

チェストの山を「整理」するのではなく、そのまま使い続けたいと思ったことはありませんか？  
そんなあなたにぴったりなのが、ストレージバスです！

ストレージバスは、接続されているインベントリを[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)として機能させます。  
ネットワークがそのインベントリの中身を参照できるようになり、ネットワーク経由でアイテムの出し入れが可能になります。  
これにより、[デバイス](../ae2-mechanics/devices.md)がネットワークストレージへアクセスする際に、そのインベントリが利用されるようになります。

AE2の「デバイス間の相互作用によって生まれるメカニクス」という設計思想により、ストレージバスは必ずしも「ストレージ用途」に限定されません。  
たとえば、[サブネットワーク](../ae2-mechanics/subnetworks.md)を使い、ストレージバス（あるいは複数）だけをストレージとして構成すれば、  
アイテム転送の送信元または送信先として使うことができます（例: [パイプサブネット](../example-setups/pipe-subnet.md)）。

**重要な注意点：**  
「引き出し」のような最適化された大規模インベントリは問題ありませんが、  
「コロッサルチェスト」のように多数のスロットを持つ最適化されていないインベントリは、  
ストレージバスと組み合わせるとパフォーマンスに大きな悪影響を及ぼします。

ストレージバスは[ケーブルサブパーツ](../ae2-mechanics/cable-subparts.md)です。

## フィルタリング

デフォルトでは、すべてのアイテムが保存対象になります。  
フィルタースロットにアイテムを入れると、ホワイトリスト方式となり、そのアイテムのみが保存されます。

実際に持っていなくても、JEI/REIからアイテムや液体をドラッグしてフィルターに設定できます。

液体コンテナ（バケツや液体タンクなど）を右クリックすると、アイテムではなく中身の液体がフィルターとして設定されます。

## 優先度

GUI右上のレンチアイコンをクリックすると優先度を設定できます。  
アイテムがネットワークに投入された場合、まず最も優先度の高いストレージを目指します。  
同じ優先度のストレージが複数ある場合、すでにそのアイテムを含んでいるストレージが優先されます。  
フィルターが設定されているストレージは、同じ優先度グループ内では「すでにアイテムを含んでいる」とみなされます。  
アイテムの取り出し時は、最も優先度の低いストレージから取り出されます。

この優先度システムにより、ネットワークへの出し入れで「高優先度ストレージが先に埋まり、低優先度ストレージが先に空になる」ようになります。

## 設定項目

* 隣接するインベントリの中身を基準に、バスのパーティション（フィルター）を設定できる
* ネットワークが、バスで取り出せないアイテムを参照することを許可／不許可にできる  
  （例：<ItemLink id="inscriber" />の中央スロットからはストレージバスでアイテムを取り出せない）
* 挿入と取り出しの両方、または挿入のみでフィルターを設定できる
* 双方向／挿入専用／取り出し専用のいずれかに設定できる

## アップグレード

ストレージバスは、以下の[アップグレード](upgrade_cards.md)に対応しています：

* <ItemLink id="capacity_card" />：フィルタースロット数を増やせる  
* <ItemLink id="fuzzy_card" />：アイテムのダメージ値やNBTを無視してフィルターできる  
* <ItemLink id="inverter_card" />：フィルターをホワイトリストからブラックリストに切り替えられる  
* <ItemLink id="void_card" />：接続先インベントリが満杯の場合、投入されたアイテムを破棄する  
  （農場などの詰まり防止に便利ですが、**必ずパーティション設定を行ってください**）

## レシピ

<RecipeFor id="storage_bus" />
