---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: スペーシャルアンカー
  icon: spatial_anchor
  position: 110
categories:
- network infrastructure
item_ids:
- ae2:spatial_anchor
---

# スペーシャルアンカー

<BlockImage id="spatial_anchor" p:powered="true" scale="8"/>

AE2ネットワークの[デバイス](../ae2-mechanics/devices.md)が正常に機能するには、ネットワーク全体がチャンクロードされている必要があります。一部しかロードされていない場合、正しく動作しない可能性があります。この問題を解決するのがスペーシャルアンカーです。ネットワークが存在するチャンクを強制的にロードします。チャンク境界をまたいで伸びたケーブル1本でも、その先のチャンクがロード対象になります。

このロード効果は[量子ネットワークブリッジ](quantum_bridge.md)を経由して伝播しますが、次元をまたぐことはできません。そのため、たとえばネザーと接続された量子ブリッジがある場合は、拠点側とネザー側の両方のネットワークにスペーシャルアンカーを設置する必要があります。

デフォルトでは、ロードされたチャンク内でランダムティックも有効になります。これはAE2の設定で無効化できます。

必要であれば、<ItemLink id="certus_quartz_wrench" />で向きを変えることも可能です。

## 設定

* スペーシャルアンカーのGUIでは、エネルギー単位（AE または E/FE）の表示切り替え設定にアクセスできます。  
* ロード中のチャンクを表示するホログラムをワールド内に表示できます。  

## エネルギー消費

スペーシャルアンカーは、以下の式に従って[エネルギー](../ae2-mechanics/energy.md)を消費します：

e = 80 + (x × (x + 1)) / 2

ここで、x はロードしているチャンク数です。

## レシピ

<RecipeFor id="spatial_anchor" />
