---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: パターンプロバイダー
  icon: pattern_provider
  position: 210
categories:
- devices
item_ids:
- ae2:pattern_provider
- ae2:cable_pattern_provider
---

# パターンプロバイダー

<Row gap="20">
  <BlockImage id="pattern_provider" scale="8" />
  <BlockImage id="pattern_provider" p:push_direction="up" scale="8" />
  <GameScene zoom="8" background="transparent">
    <ImportStructure src="../assets/blocks/cable_pattern_provider.snbt" />
  </GameScene>
</Row>

パターンプロバイダーは、あなたの[自動クラフト](../ae2-mechanics/autocrafting.md)システムが世界とやり取りする主要な手段です。  
パターンプロバイダーは、自身の[パターン](patterns.md)に定義された材料を隣接するインベントリにプッシュし、  
また、インベントリに挿入されたアイテムをネットワークに取り込めるようにします。  
多くの場合、マシンの出力を<ItemLink id="import_bus" />で取り込む代わりに、  
そのマシンの出力を近くのパターンプロバイダー（しばしば材料をプッシュした同じプロバイダー）にパイプで戻すことで、チャネルを節約できます。

クラフティングCPUの[クラフトストレージ](crafting_cpu_multiblock.md#crafting-storage)から直接材料をプッシュするため、  
パターンプロバイダー自身のインベントリに材料を保持することはなく、そこからアイテムをパイプで取り出すことはできません。  
そのため、一度バレルなど別のインベントリにプッシュしてから、そこから取り出す必要があります。

また、パターンプロバイダーは材料を一度にすべてプッシュしなければならず、半分だけプッシュすることはできません。  
この特性を活かした運用が可能です。

パターンプロバイダーは、[サブネットワーク](../ae2-mechanics/subnetworks.md)上のインターフェースと特別な相互作用を持ちます。  
インターフェースのリクエストスロットが空の場合、プロバイダーはインターフェースをスキップして直接サブネットの[ストレージ](../ae2-mechanics/import-export-storage.md)にプッシュし、  
レシピバッチをインターフェースに詰めず、次のバッチもインターフェース内の空きスペースを待たずにプッシュします。  
この動作はブロッキングモードでも正しく機能し、プロバイダーはインターフェースのスロットではなくマシン側のスロットを監視します。

たとえば、この構成では精錬対象と燃料をそれぞれ対応するスロットに直接プッシュできます。  
複数面にパターンプロバイダーを配置して複数のマシンに提供することも可能です。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/furnace_automation.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 3" max="2 1 4">
    (1) パターンプロバイダー（方向付きバリアント。<ItemLink id="certus_quartz_wrench" />で向きを変更）  
    該当する加工パターンを使用
    ![Iron Pattern](../assets/diagrams/furnace_pattern_small.png)
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 0" max="2 1.3 1">
    (2) インターフェース：デフォルト設定
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 0" max="1.3 2 1">
    (3) ストレージバス #1：石炭でフィルター
    <ItemImage id="minecraft:coal" scale="2" />
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 2 0" max="1 2.3 1">
    (4) ストレージバス #2：石炭をブラックリストに設定（インバータカード使用）
    <Row><ItemImage id="minecraft:coal" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>
  </BoxAnnotation>

  <DiamondAnnotation pos="4 0.5 0.5" color="#00ff00">
    メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

複数のパターンプロバイダーに同一のパターンを設定すると並列動作します。  
プロバイダーはバッチを全対象面にラウンドロビン方式で割り振り、接続されたマシンを並列稼働させます。

## バリアント

パターンプロバイダーには通常型、方向付き型、フラット／[サブパート](../ae2-mechanics/cable-subparts.md)型の3種類があります。  
これにより、材料をプッシュする面、アイテムを受け取る面、ネットワーク接続を提供する面が変わります。

* **通常型**：全方向に材料をプッシュし、全方向からアイテムを受け取り、多くのAE2マシンと同様に全方向にネットワーク接続を提供します。  
* **方向付き型**：通常型のパターンプロバイダーに<ItemLink id="certus_quartz_wrench" />を使用して作成します。  
  指定した面にのみ材料をプッシュし、全方向からアイテムを受け取りますが、指定面にはネットワーク接続を提供しません。  
  ネットワークを接続せずにAE2マシンに材料を送るサブネットワーク構築に便利です。  
* **フラット型**：[ケーブルサブパート](../ae2-mechanics/cable-subparts.md)扱いで、同じケーブル上に複数設置できます。  
  動作は方向付き型の指定面と同じで、材料プッシュ、アイテム受け取りを行い、その面にはネットワーク接続を提供しません。

通常型とフラット型はクラフトグリッドで相互に変換可能です。

## 設定

パターンプロバイダーは以下のモードを持ちます：

* **ブロッキングモード**：マシン内に材料が残っている間は次のバッチをプッシュしません。  
* **クラフトロック**：各種レッドストーン条件下、または前回クラフト結果がパターンプロバイダーに挿入されるまでロックできます。  
* **表示設定**：<ItemLink id="pattern_access_terminal" />上でプロバイダーを表示／非表示にできます。

## 優先度

GUI右上のレンチアイコンから優先度を設定できます。同じアイテムの複数パターンがある場合、  
高優先度のプロバイダーが優先して使用されます（ネットワークに材料が存在する限り）。

## よくある誤解

<ItemLink id="export_bus" />だけがネットワークからアイテムを取り出す手段と思っている方がいますが、  
パターンプロバイダーもアイテムをエクスポートできます。  
以下のような構成は動作しません。ケーブルは内部インベントリを持たないため、プロバイダーはケーブルにプッシュできず、  
結果的に<ItemLink id="export_bus" />につながるだけの“ケーブル”として振る舞うだけです。

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/assemblies/provider_misconception_1.snbt" />
  <BoxAnnotation color="#dddddd" min="1 0 3" max="2 1 4">
    期待した動作をしない構成
  </BoxAnnotation>
  <IsometricCamera yaw="95" pitch="5" />
</GameScene>

本来は、パターンプロバイダーがパターンの内容を隣接マシンにエクスポートできる配置にする必要があります。

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/assemblies/provider_misconception_3.snbt" />
  <BoxAnnotation color="#dddddd" min="1 0 3" max="2 1 4">
    正しい構成例
  </BoxAnnotation>
  <IsometricCamera yaw="95" pitch="5" />
</GameScene>

## 分子アセンブラーとの併用

<ItemLink id="molecular_assembler" />は通常のマシンと同様に動作します。  
パターンプロバイダーに隣接させれば、<ItemLink id="crafting_pattern" />／<ItemLink id="smithing_table_pattern" />／<ItemLink id="stonecutting_pattern" />を  
アセンブラーに直接挿入せずとも、プロバイダーがパターン情報と材料を一緒に送れます。  
これにより、アセンブラーをパターンごとに用意することなく、一台で複数の加工を自動化できます。

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/assembler_tower.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

※この構成には最大チャネル数である8プロバイダーが使用されています。

## レシピ

<RecipeFor id="pattern_provider" />

<RecipeFor id="cable_pattern_provider" />
