---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: レベルエミッター
  icon: level_emitter
  position: 220
categories:
- devices
item_ids:
- ae2:level_emitter
- ae2:energy_level_emitter
---

# レベルエミッター

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/level_emitter.snbt" />
</GameScene>

レベルエミッターは、[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)内のアイテム数に応じてレッドストーン信号を出力します。

ネットワークに蓄えられた[エネルギー](../ae2-mechanics/energy.md)に応じてレッドストーン信号を出力するバージョンもあります。

アイテムや液体は、実際に所持していなくてもJEI/REIからスロットにドラッグできます。

バケツや流体タンクなどの流体コンテナを右クリックすると、その液体をバケツやタンクアイテムの代わりにフィルターとして設定できます。

これらは[ケーブルサブパーツ](../ae2-mechanics/cable-subparts.md)です。

他の[デバイス](../ae2-mechanics/devices.md)とは異なり、レベルエミッターは[チャネル](../ae2-mechanics/channels.md)を*必要としません*。

## 設定

*   設定できます: 「以上／同値以上」モードまたは「未満」モード  
*   設定できます: <ItemLink id="crafting_card" />を挿入すると、「アイテムをクラフト中にレッドストーン信号を出力」または「クラフト時にレッドストーン信号を出力」を選択できます。  

## アップグレード

レベルエミッターは以下の[アップグレード](upgrade_cards.md)をサポートします:

*   挿入すると、<ItemLink id="fuzzy_card" />でダメージレベルによるフィルタリングやアイテムのNBT無視ができます。  
*   挿入すると、<ItemLink id="crafting_card" />でクラフト機能が使用可能になります。  

## クラフト機能

<ItemLink id="crafting_card" />を挿入すると、エミッターはクラフトモードに切り替わります。

これにより、次の2つのオプションが使用可能になります。

「アイテムをクラフト中にレッドストーン信号を出力」オプションは、<ItemLink id="pattern_provider" />を介した[自動クラフト](../ae2-mechanics/autocrafting.md)中にエミッターがレッドストーン信号を出力します。これは、電力を大量に消費する自動化セットアップを実際に使用している間のみオンにするのに便利です。

「クラフト時にレッドストーン信号を出力」オプションは、無限農場や出力が確定しない自動化セットアップなど、特定のユースケースに非常に役立ちます。この設定は、エミッターのフィルタースロットにあるアイテムに対応する仮想の[パターン](patterns.md)を自動クラフト用に作成します。（正しく機能させるには、同じアイテム用の実際のパターンを<ItemLink id="pattern_provider" />に**存在させない**でください）

この「パターン」は、素材を定義したり考慮したりしません。伝えているのは「このレベルエミッターからレッドストーン信号が出力された場合、MEシステムは近い将来か遠い将来かにかかわらず、このアイテムを受け取る」ということだけです。これは、入力素材を必要としない無限農場のオン／オフや、標準の自動クラフトでは理解できない[再帰レシピを扱うシステム](../example-setups/recursive-crafting-setup.md)（例: 丸石1個を2個に複製する機械）を起動するのに使用されます。

## レシピ

<RecipeFor id="level_emitter" />

<RecipeFor id="energy_level_emitter" />
