---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: インターフェース
  icon: interface
  position: 210
categories:
- devices
item_ids:
- ae2:interface
- ae2:cable_interface
---

# インターフェース

<Row gap="20">
<BlockImage id="interface" scale="8" />
<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/cable_interface.snbt" />
</GameScene>
</Row>

インターフェースは、小さなチェストおよび流体タンクのように動作し、スロットに設定した在庫を維持するために[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)から自動で取り込みおよび排出を行います。1ゲームティックで完了しようとするため、1ティックあたり最大9スタックの入出力が可能で、高速なアイテムパイプを使用している場合は迅速なインポート/エクスポート手段となります。

さらに、多くの流体タンクが1種類の流体しか格納できないのに対し、インターフェースはアイテムと同様に最大9種類の流体を格納できます。基本的にはチェスト/多流体タンクに追加機能を付加したものですが、ネットワークから切り離すことでその追加機能を無効化できます。したがって、多種のアイテムを少量ずつ保存したいニッチな状況で有用です。

## インターフェースの内部動作

前述のとおり、インターフェースはチェスト/タンクに多数の超強力な<ItemLink id="import_bus" />と<ItemLink id="export_bus" />および複数の<ItemLink id="level_emitter" />を組み合わせた構造をしています。

<GameScene zoom="3" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_internals.snbt" />

  <BoxAnnotation color="#dddddd" min="1.3 0.3 1.3" max="9.7 1 1.7">
        要求在庫量を制御するレベルエミッタ群
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/level_emitter.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 4 1.3" max="9.7 4.7 1.7">
        要求在庫量を制御するレベルエミッタ群
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/level_emitter.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 1.3 1.3" max="9.7 2 1.7">
        1スタック/ティックを転送できる超強力インポートバス群
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/import_bus.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 3 1.3" max="9.7 3.7 1.7">
        1スタック/ティックを転送できる超強力エクスポートバス群
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/export_bus.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 1" max="10 3 2">
        9つの独立した内部スロット
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="15" />
</GameScene>

## 特殊な機能

インターフェースは、他のAE2[デバイス](../ae2-mechanics/devices.md)ともいくつか特殊な機能を持ちます:

<ItemLink id="storage_bus" />を未設定のインターフェースに設置すると、そのインターフェースが属するネットワークの[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)全体が、まるで1つの大きなチェストとしてストレージバスのネットワークに表示されます。インターフェースのフィルタスロットに在庫設定を行うと、この動作は無効化されます。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_storage.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

パターンプロバイダーは、[サブネット](../ae2-mechanics/subnetworks.md)上のインターフェースと特殊な相互作用を持ちます: インターフェースが未設定の場合、プロバイダーはインターフェースを完全にスキップし、そのままサブネットの[ストレージ](../ae2-mechanics/import-export-storage.md)に直接投入します。この動作により、インターフェースにレシピバッチを詰めず、さらにストレージに空きができるまで次のバッチを挿入しません。

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/provider_interface_storage.snbt" />

<BoxAnnotation color="#dddddd" min="2.7 0 1" max="3 1 2">
        インターフェース（フラット形状、フルブロックではない）
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 4">
        ストレージバス
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 0 0" max="1 1 4">
        パターンプロバイド対象（複数のマシン、または1台のマシンの複数面）
  </BoxAnnotation>

<IsometricCamera yaw="185" pitch="30" />
</GameScene>

## バリエーション

インターフェースには通常型とフラット型/[サブパート](../ae2-mechanics/cable-subparts.md)の2種類があります。これにより、インベントリへのアクセス可能な面やネットワーク接続を提供する面が変わります。

*   通常型インターフェースは、すべての面からアイテムのプッシュ／プルおよびインベントリへのアクセスが可能で、ほとんどのAE2マシンと同様にすべての面にネットワーク接続を提供します。  
*   フラット型インターフェースは[ケーブルサブパート](../ae2-mechanics/cable-subparts.md)であり、同一ケーブル上に複数設置できるため、コンパクトな構成が可能です。フェイスからのみアイテムのプッシュ／プルおよびインベントリへのアクセスが可能で、フェイスにはネットワーク接続を提供しません。

インターフェースはクラフトグリッド上で通常型とフラット型を切り替えることができます。

## 設定

インターフェース上部のスロットは、内部に在庫するアイテムを設定します。これらのスロットにアイテムを配置するか、JEI/REIからドラッグすると、数量を設定できるレンチアイコンが表示されます。

バケツや流体タンクなどの流体コンテナを右クリックすると、その流体自体をフィルターとして設定できます。

スロットを在庫モードに設定すると、外部の機械がそのスロットへの挿入を防ぎます。

## アップグレード

*   <ItemLink id="fuzzy_card" /> により、バスが耐久度レベルでフィルタをかけたり、アイテムのNBTを無視したりできます。  
*   <ItemLink id="crafting_card" /> により、インターフェースは必要なアイテムを取得するために[自動作成](../ae2-mechanics/autocrafting.md)システムへクラフトリクエストを送信できます。可能な場合はストレージからアイテムを引き出し、それが不可能な場合に新規クラフトをリクエストします。

## 優先度

優先度はGUI右上のレンチアイコンをクリックして設定できます。優先度が高いインターフェースほど、優先的にアイテムを取得します。

## レシピ

<Recipe id="network/blocks/interfaces_interface" />

<RecipeFor id="cable_interface" />
