---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: インスクライバー
  icon: inscriber
  position: 310
categories:
- machines
item_ids:
- ae2:inscriber
---

# インスクライバー

<BlockImage id="inscriber" scale="8" />

インスクライバーは、[プレス](presses.md)を使って回路や[プロセッサ](processors.md)を刻印したり、さまざまなアイテムを粉砕してダストに加工したりする機械です。  
AE2のエネルギー（AE）またはFabric/Forgeエネルギー（E/FE）のいずれかを受け取れます。  
側面ごとにスロットへの入出力を分ける「サイド設定」が可能で、<ItemLink id="certus_quartz_wrench" />で回転させることで向きを変えられます。  
また、クラフト結果を隣接インベントリへ自動でプッシュするよう設定することもできます。

投入バッファのサイズは調整可能です。  
たとえば、大量のインスクライバーを連結して1つのインベントリからまとめて供給する場合は、バッファを小さくすると素材が各インスクライバーに均等に分配されます。

下記の4種類の回路プレスでプロセッサをクラフトします。

<Row>
  <ItemImage id="silicon_press" scale="4" />

  <ItemImage id="logic_processor_press" scale="4" />

  <ItemImage id="calculation_processor_press" scale="4" />

  <ItemImage id="engineering_processor_press" scale="4" />
</Row>

また、名前プレス（<ItemImage id="name_press" scale="4" />）は金床のようにブロックに名前を付ける用途に使え、  
<ItemLink id="pattern_access_terminal" />のラベリングなどに便利です。

## 設定

* サイド設定モード：隣接する面ごとに投入・取り出しスロットを割り当てるか、  
  全面共通モードにして内部フィルターで振り分けるかを選択できます。  
  ※共通モードでは上下スロットからの取り出しができません。  
* クラフト結果の自動プッシュ：隣接インベントリへ結果を送信するか設定できます。  
* 投入バッファ容量：大きいバッファは手動給材向け、小さいバッファは並列運用向けです。

## GUIとサイド設定

サイド設定モード時、各面からの入出力でスロットを自動振り分けします。

![インスクライバーGUI](../assets/diagrams/inscriber_gui.png) ![インスクライバーの面](../assets/diagrams/inscriber_sides.png)

A. **上部投入スロット**：上面からアクセス（投入・取り出し可能）  
B. **中央投入スロット**：左右・前後面からアクセス（投入のみ可能）  
C. **下部投入スロット**：下面からアクセス（投入・取り出し可能）  
D. **出力スロット**：左右・前後面からアクセス（取り出しのみ可能）

## 簡易自動化

サイド設定と回転機能を活かすと、チェストとホッパーを組み合わせて半自動化できます：

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/inscriber_hopper_automation.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

もちろん、サイド設定をOFFにして単純にパイプで入出力することも可能です。

## アップグレード

インスクライバーは以下の[アップグレード](upgrade_cards.md)に対応しています：

*   <ItemLink id="speed_card" />  

## レシピ

<RecipeFor id="inscriber" />
