---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: クラフティングCPUマルチブロック（ストレージ、共処理ユニット、モニター、ユニット）
  icon: 1k_crafting_storage
  position: 210
categories:
- devices
item_ids:
- ae2:1k_crafting_storage
- ae2:4k_crafting_storage
- ae2:16k_crafting_storage
- ae2:64k_crafting_storage
- ae2:256k_crafting_storage
- ae2:crafting_accelerator
- ae2:crafting_monitor
- ae2:crafting_unit
---

# クラフティングCPU

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/crafting_cpus.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<Row>
  <BlockImage id="1k_crafting_storage" scale="4" />

  <BlockImage id="crafting_accelerator" scale="4" />

  <BlockImage id="crafting_monitor" scale="4" />

  <BlockImage id="crafting_unit" scale="4" />
</Row>

クラフティングCPUはクラフト要求やジョブを管理します。中間素材を保存しながら複数段階の処理を実行し、ジョブの規模や処理速度に影響を与えます。詳細は[自動クラフト](../ae2-mechanics/autocrafting.md)を参照してください。

各CPUは一つの要求またはジョブを処理します。そのため、計算プロセッサと滑らかな石256個を同時に要求する場合は、CPUマルチブロックを2つ用意する必要があります。

## 設定

* CPUをプレイヤーのみ、オートメーションのみ、または両方からの要求を受け付けるよう設定できる。

## 構築

クラフティングCPUはマルチブロック構造で、隙間のない直方体として構築する必要があります。複数のコンポーネントから構成されます。  
各CPUは最低でも1つのクラフティングストレージブロックを含む必要があります（実際には1kクラフティングストレージ1個のみでも動作します）。

# クラフティングユニット

<BlockImage id="crafting_unit" scale="4" />

（任意）クラフティングユニットは、他のコンポーネントが不足している場合に直方体形状を維持するための詰め物として機能します。また、ほかのコンポーネントの材料としても使用されます。

<RecipeFor id="crafting_unit" />

# クラフティングストレージ

<Row>
  <BlockImage id="1k_crafting_storage" scale="4" />

  <BlockImage id="4k_crafting_storage" scale="4" />

  <BlockImage id="16k_crafting_storage" scale="4" />

  <BlockImage id="64k_crafting_storage" scale="4" />

  <BlockImage id="256k_crafting_storage" scale="4" />
</Row>

（必須）クラフティングストレージは1k、4k、16k、64k、256kの全サイズが利用できます。これらはクラフトに必要な材料や中間素材を格納するため、大規模なジョブにはより大きい、または複数のストレージが必要です。

<Column>
  <Row>
    <RecipeFor id="1k_crafting_storage" />

    <RecipeFor id="4k_crafting_storage" />

    <RecipeFor id="16k_crafting_storage" />
  </Row>

  <Row>
    <RecipeFor id="64k_crafting_storage" />

    <RecipeFor id="256k_crafting_storage" />
  </Row>
</Column>

# クラフティング共処理ユニット

<BlockImage id="crafting_accelerator" scale="4" />

（任意）クラフティング共処理ユニットは、CPUの処理速度を向上させ、<ItemLink id="pattern_provider" />から材料バッチをより頻繁に送出するようにします。これにより、高速処理機械の処理速度に追従できます。たとえば、分子アセンブラーに囲まれたパターンプロバイダーは、単一のアセンブラーが処理できる速度を超えて材料バッチを配布できます。

複数のステップを並列処理可能な複雑なレシピ（例：本棚を作る際に原木と本を同時に作る）の場合、クラフトステータス画面（CPUを右クリックするか[ターミナル](terminals.md)のハンマーアイコン）でステップが「スケジュール済み」と表示されます。共処理ユニットを1つ追加するごとに、これらのステップを1つずつ並列（「クラフト中」と表示）で処理できます。ただし、一般にはステップ数以上に共処理ユニットを設置することが多いです。

<RecipeFor id="crafting_accelerator" />

# クラフティングモニター

<BlockImage id="crafting_monitor" scale="4" />

（任意）クラフティングモニターは、CPUが現在処理しているジョブの状況を表示します。画面は<ItemLink id="color_applicator" />で着色できます。

<RecipeFor id="crafting_monitor" />
