---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: コントローラー
  icon: controller
  position: 110
categories:
- network infrastructure
item_ids:
- ae2:controller
---

# コントローラー

<BlockImage id="controller" p:state="online" scale="8" />

コントローラーは[MEネットワーク](../ae2-mechanics/me-network-connections.md)のルーティングハブです。コントローラーがないとネットワークは「アドホック」となり、チャンネルを消費する[デバイス](../ae2-mechanics/devices.md)を合計で8台までしか接続できません。

同一の[MEネットワーク](../ae2-mechanics/me-network-connections.md)にコントローラーを2つ設置することはできません。

コントローラーは各面あたり32の[チャンネル](../ae2-mechanics/channels.md)を提供します。

コントローラーは動作に1ブロックあたり6 AE/tを消費し、各ブロックは8000 AEを蓄えられます。大規模なネットワークでは追加のエネルギー貯蔵が必要になる場合があります。詳細は[エネルギー](../ae2-mechanics/energy.md)を参照してください。

マルチブロックコントローラーは比較的自由な形状で構築できます。

<GameScene zoom="2" background="transparent">
  <ImportStructure src="../assets/assemblies/controllers.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

ただし、以下のルールを守る必要があります:

1.  [MEネットワーク](../ae2-mechanics/me-network-connections.md)上のすべてのコントローラーブロックは連続して接続されていなければなりません。接続が切れているブロックは赤く表示されます。  
2.  コントローラー全体のサイズは7×7×7以内である必要があります。サイズを超えると赤く表示されます。  
3.  1つの軸に隣接できるコントローラーブロックは最大2つまでです。これを超える配置は動作停止し赤く表示されます。  

<GameScene zoom="2" background="transparent">
  <ImportStructure src="../assets/assemblies/controller_rules.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

すべてのルールを満たし、電力が供給されている状態では、コントローラーは点灯して色が変化します。

コントローラーを右クリックすると、<ItemLink id="network_tool" />と同じGUIが開きます。

## レシピ

<RecipeFor id="controller" />
