---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: MEチェスト
  icon: chest
  position: 210
categories:
- devices
item_ids:
- ae2:chest
---

# MEチェスト

<GameScene zoom="8" background="transparent">
<ImportStructure src="../assets/blocks/chest.snbt" />
</GameScene>

MEチェストは、<ItemLink id="terminal" />、<ItemLink id="drive" />、<ItemLink id="energy_acceptor" />を備えた小型ネットワークのように動作します。  
単一の[ストレージセル](../items-blocks-machines/storage_cells.md)しか搭載できないため、小規模なストレージネットワークとしての用途は限られます。

代わりに、内部にセットしたストレージセルとのやり取りに便利です。統合端末は搭載ドライブ内のアイテムのみを参照・操作でき、  
一般ネットワーク上の[デバイス](../ae2-mechanics/devices.md)はMEチェストを含む任意の[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)にアクセスできます。

MEチェストには2種類のGUIがあり、アイテム輸送用にサイド設定が可能です。  
上部の端末に対して操作すると統合端末が開き、この面からストレージセルにアイテムを挿入できますが、取り出しはできません。  
他の面を操作すると、セルスロットと優先度設定があるGUIが開きます。セルの挿入・取り出しはセルスロット面からのみ行われます。

<ItemLink id="certus_quartz_wrench" />で回転させて向きを変えられます。

内蔵のAEエナジーバッファは小容量なため、[エネルギーセル](../items-blocks-machines/energy_cells.md)がないネットワークでは、  
大量のアイテム投入・取り出しで一時的に電力不足になることがあります。

端末は<ItemLink id="color_applicator" />で色を変更できます。

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/chest_color.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="terminal" />や<ItemLink id="crafting_terminal" />と同様の設定を利用できる  
* <ItemLink id="view_cell" />には対応していない  

## セルステータスLED

チェスト内セルのLEDは以下の状態を示します：

| 色     | ステータス                                                                       |
| :----- | :------------------------------------------------------------------------------- |
| 緑     | 空                                                                               |
| 青     | 内容あり                                                                         |
| 橙     | [種類](../ae2-mechanics/bytes-and-types.md)上限に達し、新規種類を追加不可        |
| 赤     | [バイト](../ae2-mechanics/bytes-and-types.md)上限に達し、挿入不可              |
| 黒     | 電力なし、またはドライブに[チャネル](../ae2-mechanics/channels.md)がない     |

## 優先度

セルスロットGUI右上のレンチアイコンをクリックすると優先度を設定できます。  
アイテムがネットワークに投入されると、まず最も優先度の高いストレージから投入されます。  
同じ優先度のストレージが複数ある場合、既にそのアイテムを含むストレージが優先されます。  
同じ優先度グループ内で[パーティション](cell_workbench.md)済みセルは「すでに該当アイテムを含む」とみなされます。  
取り出しは最も優先度の低いストレージから行われます。  
この優先度システムにより、高優先度ストレージが先に満たされ、低優先度ストレージが先に空になる動作が実現します。

## レシピ

<RecipeFor id="chest" />
