---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: ケーブル
  icon: fluix_glass_cable
  position: 110
categories:
- network infrastructure
item_ids:
- ae2:white_glass_cable
- ae2:orange_glass_cable
- ae2:magenta_glass_cable
- ae2:light_blue_glass_cable
- ae2:yellow_glass_cable
- ae2:lime_glass_cable
- ae2:pink_glass_cable
- ae2:gray_glass_cable
- ae2:light_gray_glass_cable
- ae2:cyan_glass_cable
- ae2:purple_glass_cable
- ae2:blue_glass_cable
- ae2:brown_glass_cable
- ae2:green_glass_cable
- ae2:red_glass_cable
- ae2:black_glass_cable
- ae2:fluix_glass_cable
- ae2:white_covered_cable
- ae2:orange_covered_cable
- ae2:magenta_covered_cable
- ae2:light_blue_covered_cable
- ae2:yellow_covered_cable
- ae2:lime_covered_cable
- ae2:pink_covered_cable
- ae2:gray_covered_cable
- ae2:light_gray_covered_cable
- ae2:cyan_covered_cable
- ae2:purple_covered_cable
- ae2:blue_covered_cable
- ae2:brown_covered_cable
- ae2:green_covered_cable
- ae2:red_covered_cable
- ae2:black_covered_cable
- ae2:fluix_covered_cable
- ae2:white_covered_dense_cable
- ae2:orange_covered_dense_cable
- ae2:magenta_covered_dense_cable
- ae2:light_blue_covered_dense_cable
- ae2:yellow_covered_dense_cable
- ae2:lime_covered_dense_cable
- ae2:pink_covered_dense_cable
- ae2:gray_covered_dense_cable
- ae2:light_gray_covered_dense_cable
- ae2:cyan_covered_dense_cable
- ae2:purple_covered_dense_cable
- ae2:blue_covered_dense_cable
- ae2:brown_covered_dense_cable
- ae2:green_covered_dense_cable
- ae2:red_covered_dense_cable
- ae2:black_covered_dense_cable
- ae2:fluix_covered_dense_cable
- ae2:white_smart_cable
- ae2:orange_smart_cable
- ae2:magenta_smart_cable
- ae2:light_blue_smart_cable
- ae2:yellow_smart_cable
- ae2:lime_smart_cable
- ae2:pink_smart_cable
- ae2:gray_smart_cable
- ae2:light_gray_smart_cable
- ae2:cyan_smart_cable
- ae2:purple_smart_cable
- ae2:blue_smart_cable
- ae2:brown_smart_cable
- ae2:green_smart_cable
- ae2:red_smart_cable
- ae2:black_smart_cable
- ae2:fluix_smart_cable
- ae2:white_smart_dense_cable
- ae2:orange_smart_dense_cable
- ae2:magenta_smart_dense_cable
- ae2:light_blue_smart_dense_cable
- ae2:yellow_smart_dense_cable
- ae2:lime_smart_dense_cable
- ae2:pink_smart_dense_cable
- ae2:gray_smart_dense_cable
- ae2:light_gray_smart_dense_cable
- ae2:cyan_smart_dense_cable
- ae2:purple_smart_dense_cable
- ae2:blue_smart_dense_cable
- ae2:brown_smart_dense_cable
- ae2:green_smart_dense_cable
- ae2:red_smart_dense_cable
- ae2:black_smart_dense_cable
- ae2:fluix_smart_dense_cable
---

# ケーブル

<GameScene zoom="3" background="transparent">
  <ImportStructure src="../assets/assemblies/cables.snbt" />
  <IsometricCamera yaw="180" pitch="30" />
</GameScene>

MEネットワークはME対応機器を隣接配置することで構築できますが、ケーブルはより広範囲にネットワークを拡張する主な手段です。

異なる色のケーブルを使うことで、隣接するケーブル同士が接続しないようにでき、[チャンネル](../ae2-mechanics/channels.md)を効率的に分配できます。また、ターミナルの色も接続したケーブルの色に影響されるため、ターミナルをすべて紫色に揃える必要がありません。フルークスケーブルはすべての色と接続できます。

**注意: チャンネルはケーブルの色とは無関係です**

## 重要な注意点

AE2に不慣れでチャンネルの仕組みを理解していない場合は、可能な限りスマートケーブルとデンススマートケーブルを使用してください。ネットワーク上でチャンネルがどのようにルーティングされているか可視化され、動作を把握しやすくなります。

## 補足

これらはアイテム管や流体管、エネルギー管などではありません。内部インベントリを持たず、パターンプロバイダーや機械が「プッシュ」することもありません。AE2の[デバイス](../ae2-mechanics/devices.md)同士をネットワークへ接続する機能のみを備えています。

## ガラスケーブル

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/fluix_glass_cable.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

<ItemLink id="fluix_glass_cable" />は最も簡単に作製できるケーブルで、電力と最大8つのチャンネルを転送できます。デフォルト色はフルークスですが、全17色あり、16種類の染料を使って任意の色に染めることができます。

染色したケーブルを作製するには、任意の染料1つを同種のケーブル8本で囲みます（ケーブルの色は問いませんが、ガラスケーブル同士など同一種である必要があります）。ワールド内でフォージ対応のペイントブラシを使ってケーブルを塗装することも可能です。

水入りバケツを用いるとケーブルから染料を洗い落として任意の色付きケーブルを作製できます。

ウールでケーブルを覆うと<ItemLink id="fluix_covered_cable" />を作製でき、<ItemLink id="fluix_smart_cable" />をクラフトすると[チャンネル]の挙動を視覚的に把握しやすくなります。

<RecipeFor id="fluix_glass_cable" />

<RecipeFor id="blue_glass_cable" />

## 被覆ケーブル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/fluix_covered_cable.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

被覆ケーブルは<ItemLink id="fluix_glass_cable" />と性能面で差はありませんが、見た目を変えたい場合の美的選択肢として利用できます。

<ItemLink id="fluix_glass_cable" />と同様に染色でき、<ItemLink id="fluix_covered_cable" />4本をレッドストーンとグロウストーンで囲むと<ItemLink id="fluix_covered_dense_cable" />を作製できます。

<Recipe id="network/cables/covered_fluix" />

<RecipeFor id="blue_covered_cable" />

## 高密度ケーブル

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/fluix_covered_dense_cable.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

高密度ケーブルは通常のガラスケーブル（8チャンネル）より多く、32チャンネルを転送できます。ただしバスを直接接続できないため、Denseケーブルからバスやパネルを使用する際は一度小型ケーブル（<ItemLink id="fluix_glass_cable" />や<ItemLink id="fluix_smart_cable" />など）に変換する必要があります。

高密度ケーブルはチャンネルの「最短経路」挙動を若干上書きし、チャンネルは高密度ケーブルへの最短経路と、高密度ケーブル内での最短経路の2段階でルーティングされます。

<Recipe id="network/cables/dense_covered_fluix" />

<RecipeFor id="blue_covered_dense_cable" />

## スマートケーブル

<Row>
<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/fluix_smart_cable.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>
<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/fluix_smart_dense_cable.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>
</Row>

<ItemLink id="fluix_covered_cable" />に似た外観ですが、ケーブル上の黒いストライプに沿って点灯するカラフルなラインでチャンネル使用状況を可視化します。スマートケーブルは最初の4チャンネルをケーブル色のラインで、次の4チャンネルを白いラインで表示します。デンススマートケーブルではストライプ1本が4チャンネルを表します。

コントローラーが接続されたネットワークでは、ケーブル上のラインがチャンネルの実際の経路を示します。コントローラー非搭載のアドホックネットワークでは、ケーブル単体ではなくネットワーク全体のチャンネル使用数を表示します。

<ItemLink id="fluix_glass_cable" />と同様に染色が可能です。

<Recipe id="network/cables/smart_fluix" />

<Recipe id="network/cables/dense_smart_fluix" />

<RecipeFor id="blue_smart_cable" />
