---
navigation:
  parent: example-setups/example-setups-index.md
  title: 水中投入レシピの自動化
  icon: fluix_crystal
---

# 水中投入レシピの自動化

この構成では<ItemLink id="pattern_provider" />を使用するため、[自動クラフト](../ae2-mechanics/autocrafting.md)のセットアップに統合することを想定しています。

一部のレシピではアイテムを水中に投げ込む必要があります（同様の構成を利用して他の場所に投げることもできます）。  
これは<ItemLink id="formation_plane" />, <ItemLink id="annihilation_plane" />, およびいくつかの補助インフラを用いることで自動化できます（本質的には改変された2つの[パイプサブネット](pipe-subnet.md)です）。  
本構成は[チャージャー自動化](charger-automation.md)と組み合わせて<ItemLink id="charged_certus_quartz_crystal" />を供給することを想定しています。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/throw_in_water.snbt" />

  <BoxAnnotation color="#dddddd" min="2 0 1" max="3 1 2">
    (1) MEパターンプロバイダー：デフォルト設定で関連する処理パターンが登録されています。

    ![フルークスクリスタルのパターン](../assets/diagrams/fluix_pattern_small.png) ![不完全な芽生えたサータスクォーツのパターン](../assets/diagrams/flawed_budding_pattern_small.png)
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.7 0 1" max="2 1 2">
    (2) MEインターフェース：デフォルト設定です。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 .7 1" max="2 1 2">
    (3) MEフォーメーションプレーン：入力をアイテムとしてドロップするよう設定されています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 1" max="2 2.3 2">
    (4) ME殲滅プレーン：設定用GUIがありません。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 1 1" max="3 1.3 2">
    (5) MEストレージバス：パターンの出力にフィルター設定されています。
    <Row><ItemImage id="fluix_crystal" scale="2" /><BlockImage id="flawless_budding_quartz" scale="2" /></Row>
  </BoxAnnotation>

  <DiamondAnnotation pos="3.9 0.5 1.5" color="#00ff00">
    メインネットワークおよびチャージャー自動化へ
    <GameScene zoom="3" background="transparent">
      <ImportStructure src="../assets/assemblies/charger_automation.snbt" />
      <IsometricCamera yaw="195" pitch="30" />
    </GameScene>
  </DiamondAnnotation>

  <IsometricCamera yaw="180" pitch="0" />
</GameScene>

## 設定とパターン

* 設定する：<ItemLink id="pattern_provider" />(1)をデフォルト構成にし、関連する<ItemLink id="processing_pattern" />を登録する。  
  * 使用する：<ItemLink id="fluix_crystal" />にJEI/REI標準のレシピを使用する。  

    ![フルークスクリスタルのパターン](../assets/diagrams/fluix_pattern.png)  
  * 直接作成する：<ItemLink id="flawed_budding_quartz" />を<ItemLink id="quartz_block" />から直接作成し、あるレシピの入力が別のレシピの出力となりMEストレージバスがフィルタリングできなくなる問題を回避する。  

    ![不完全な芽生えたサータスクォーツのパターン](../assets/diagrams/flawed_budding_pattern.png)  
* 使用する：<ItemLink id="interface" />(2)をデフォルト設定で使用する。  
* 設定する：<ItemLink id="formation_plane" />(3)を入力をアイテムとしてドロップするよう設定する。  
* 設定できない：<ItemLink id="annihilation_plane" />(4)はGUIがなく設定できない。  
* フィルター設定する：<ItemLink id="storage_bus" />(5)をパターンの出力のみに絞る。  

## 動作の仕組み

1. <ItemLink id="pattern_provider" />が緑色サブネット側の<ItemLink id="interface" />に材料をプッシュします。  
2. インターフェースは（デフォルトで何も保持しない設定になっているため）[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)に内容をプッシュしようとします。  
3. 緑色サブネット上の唯一のストレージは<ItemLink id="formation_plane" />で、受け取ったアイテムを水中にドロップします。  
4. オレンジ色サブネット上の<ItemLink id="annihilation_plane" />は直前にドロップされたアイテムをピックアップしようとしますが、  
    パターンプロバイダーの上にある<ItemLink id="storage_bus" />（オレンジ色サブネット上の唯一のストレージ）がクラフト結果のみを受け入れるようフィルター設定されているためピックアップできません。  
5. アイテムがワールド内で変化します。  
6. ME殲滅プレーンは前方のアイテムをピックアップできるようになります。これはMEストレージバスがアイテムを格納できるためです。  
7. MEストレージバスが生成されたアイテムをMEパターンプロバイダーに格納し、ネットワークに戻します。  
