---
navigation:
  parent: example-setups/example-setups-index.md
  title: 専用ローカルストレージ
  icon: drive
---

# 専用ローカルストレージ

[インターフェース](../items-blocks-machines/interface.md#special-interactions)の特殊な挙動の１つを利用すると、[サブネットワーク](../ae2-mechanics/subnetworks.md)はメインネットワークのストレージを参照せずに、自身のストレージ内容を１チャンネルだけでメインネットワークに表示できます。  
これはファームなどでローカルストレージを構築し、アイテムがメインストレージにあふれ出るのを防ぐのに便利です。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/local_storage.snbt" />

  <BoxAnnotation color="#dddddd" min="4 0 0" max="5 2 1">
        (1) アイテムをインポートする方法（ここではインターフェース）
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 0 0" max="4 1 1">
        (2) ドライブ：いくつかのセルを挿入しています。セルはファームの出力アイテムにフィルター設定してください。セルには<ItemImage id="item_storage_cell_4k" scale="2" />、<ItemImage id="equal_distribution_card" scale="2" />、<ItemImage id="void_card" scale="2" />を装着できます。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 0" max="4 2 0.3">
        (3) クラフティングターミナル：サブネットワーク上のドライブの内容だけを確認でき、メインネットワークのストレージ内容は見えません。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 0 0" max="2.3 1 1">
        (4) インターフェース #2：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.7 0 0" max="2 1 1">
        (5) ストレージバス：メインストレージより優先度を高く設定し、ファームの出力に応じてフィルター設定できます。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 0" max="2 2 0.3">
        クラフティングターミナル：メインネットワークのストレージとサブネットワークの両方を確認できます。
  </BoxAnnotation>

  <DiamondAnnotation pos="0 0.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* 最初の<ItemLink id="interface" />(1)は、ファームから流れてくるアイテムを受け取り、サブネットワークへプッシュします。  
* <ItemLink id="drive" />(2)には[セル](../items-blocks-machines/storage_cells.md)を挿入し、ファームの出力アイテムにパーティション設定します。セルには<ItemLink id="equal_distribution_card" />や<ItemLink id="void_card" />を装着できます。  
* 2番目の<ItemLink id="interface" />(4)はデフォルト設定のままにします。  
* <ItemLink id="storage_bus" />(5)は[優先度](../ae2-mechanics/import-export-storage.md#storage-priority)をメインストレージより高く設定し、ファームの出力アイテムにフィルター設定します。  

## 仕組み

* サブネットワーク上の<ItemLink id="interface" />は、メインネットワーク上の<ItemLink id="storage_bus" />にドライブの内容を表示します。これによりストレージバスはドライブ内のセルから直接アイテムを取り出し、またセルへ直接プッシュできます。  
* ストレージバスは優先度を高く設定しているため、アイテムはメインストレージではなくサブネットワークへ優先的に戻されます。  
* 重要なのは、サブネットワーク内のセルが満杯になってもメインネットワークにあふれ出ることがない点です。ファームがバックアップで停止するタイプの場合は、<ItemLink id="void_card" />で余分なアイテムを破棄できます。  
* ファームが複数のアイテムを出力する場合は、<ItemLink id="equal_distribution_card" />を使って一方のアイテムだけがセルを埋めるのを防ぎ、他のアイテムも適切に保存できます。  
