---
navigation:
  parent: example-setups/example-setups-index.md
  title: 再帰的クラフト構成
  icon: minecraft:netherite_upgrade_smithing_template
---

# 再帰的クラフト構成

[自動クラフティング](../ae2-mechanics/autocrafting.md)では、主産物が投入物の一つであるレシピを処理できません。例えば、<ItemLink id="minecraft:netherite_upgrade_smithing_template" />の複製は扱えません。

解決策の一つとして、<ItemLink id="level_emitter" />が[パターン](../items-blocks-machines/patterns.md)のふりをできる機能を利用します。

これを用いてクラフトを常時実行する小規模な構成を起動します。ここでは、<ItemLink id="minecraft:netherite_upgrade_smithing_template" />の複製を行う構成を見ていきます。

<RecipeFor id="minecraft:netherite_upgrade_smithing_template" />

***

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/recursive_recipe_setup.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 0" max="2 1 1">
        (1) インターフェース：必要な追加素材（ダイヤモンドとネザーラック）を在庫するよう設定します。
        <Row><ItemImage id="minecraft:diamond" scale="2" /> <ItemImage id="minecraft:netherrack" scale="2" /></Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 1 0.3" max="2.7 1.3 0.7">
        (2) レベルエミッター：『ネザライト鍛冶テンプレート』を設定し、『アイテムクラフト時にレッドストーンを出力』に設定します。
        <Row><ItemImage id="minecraft:netherite_upgrade_smithing_template" scale="2" /> <ItemImage id="crafting_card" scale="2" /></Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 0 0" max="2.3 1 1">
        (3) インポートバス #1：インターフェースが在庫しているアイテムをフィルターに設定します。レッドストーンカードを装着し、レッドストーンモードを『信号で動作』に設定します。
        <Row>
        <ItemImage id="minecraft:diamond" scale="2" />
        <ItemImage id="minecraft:netherrack" scale="2" />
        <ItemImage id="redstone_card" scale="2" />
        </Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 1" max="4 1.3 2">
        (4) ストレージバス #1：他のストレージバスより高い優先度に設定します。非常に重要です。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 0 1" max="4 1 2">
        (5) モレキュラーアセンブラー：鍛冶テンプレートを複製するパターンがセットされています。

        ![Pattern](../assets/diagrams/smithing_template_pattern_small.png)

        初回構築時に鍛冶テンプレートを1つ手動で挿入しておく必要があります。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.7 0 1" max="3 1 2">
        (6) インポートバス #2：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 1" max="2 1 1.3">
        (7) ストレージバス #2：『ネザライト鍛冶テンプレート』をフィルターに設定し、他のストレージバスより低い優先度に設定します。
        <ItemImage id="minecraft:netherite_upgrade_smithing_template" scale="2" />
  </BoxAnnotation>

<DiamondAnnotation pos="0 0.5 0.5" color="#00ff00">
        メインネットワークへ
    </DiamondAnnotation>

  <IsometricCamera yaw="15" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="interface" />(1)：必要な追加素材（ダイヤモンドとネザーラック）を在庫するよう設定します。  
* <ItemLink id="level_emitter" />(2)：『ネザライト鍛冶テンプレート』を設定し、『アイテムクラフト時にレッドストーンを出力』に設定します。  
* 最初の <ItemLink id="import_bus" />(3)：インターフェースが在庫するアイテムをフィルター設定します。レッドストーンカードを装着し、レッドストーンモードを『信号で動作』に設定します。  
* 最初の <ItemLink id="storage_bus" />(4)：2番目のストレージバスより*高い* [優先度](../ae2-mechanics/import-export-storage.md#storage-priority)に設定します。  
* <ItemLink id="molecular_assembler" />(5)：鍛冶テンプレート複製用のパターンが登録されており、初回構築時に鍛冶テンプレートが1つ手動で挿入されています。  

  ![Pattern](../assets/diagrams/smithing_template_pattern.png)

* 2番目の <ItemLink id="import_bus" />(6)：デフォルト設定のままです。  
* 2番目の <ItemLink id="storage_bus" />(7)：『ネザライト鍛冶テンプレート』をフィルターに設定し、1番目のストレージバスより*低い* [優先度](../ae2-mechanics/import-export-storage.md#storage-priority)に設定します。  

## 仕組み

1. <ItemLink id="level_emitter" /> は <ItemLink id="crafting_card" /> を挿入し『アイテムクラフト時にレッドストーンを出力』に設定することで、[パターン](../items-blocks-machines/patterns.md)のふりをします。そのため、『ネザライト鍛冶テンプレート』が[ターミナル](../items-blocks-machines/terminals.md)に有効な[自動クラフティング](../ae2-mechanics/autocrafting.md)対象として表示されます。  
2. プレイヤーまたはシステムからそのアイテムのクラフト要求を受けると、レベルエミッターが動作します。  
3. レベルエミッターにより最初の <ItemLink id="import_bus" /> が動作し、<ItemLink id="interface" /> に在庫された素材を取り出します。  
4. その素材を保管できるネットワーク上の唯一の <ItemLink id="storage_bus" /> はアセンブラー上のものです。  
5. <ItemLink id="molecular_assembler" /> が素材を受け取り（既に鍛冶テンプレートが1つ挿入された状態）、クラフトを実行して鍛冶テンプレートを2つ生成します。  
6. 2番目の <ItemLink id="import_bus" /> が鍛冶テンプレートを1つ抽出します。  
7. 優先度が高い最初のストレージバスにより、その鍛冶テンプレートは再びアセンブラーに戻されます。  
8. 再度 2番目の <ItemLink id="import_bus" /> が鍛冶テンプレートを1つ抽出します。  
9. これ以上アセンブラーに挿入できないため、2つ目の鍛冶テンプレートは低い優先度のストレージバスを経由してインターフェースに送られます。  
10. インターフェースは鍛冶テンプレートを在庫する設定ではないため、ネットワークに挿入します。  
