---
navigation:
  parent: example-setups/example-setups-index.md
  title: アイテム／液体「パイプ」サブネット
  icon: storage_bus
---

# アイテム／液体「パイプ」サブネット

これは AE2 の [デバイス](../ae2-mechanics/devices.md) を使って、アイテムや液体のパイプのような動作を再現する単純な方法です。クラフト結果を <ItemLink id="pattern_provider" /> に戻すような用途など、あらゆる場面で活用できます。

一般的には、以下の2通りの構成があります：

---

## インポートバス → ストレージバス

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/import_storage_pipe.snbt" />

  <BoxAnnotation color="#dddddd" min="3.7 0 0" max="4 1 1">
    (1) インポートバス：フィルター可能。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 1">
    (2) ストレージバス：フィルター可能。これ（と他のストレージバス）がネットワーク上の唯一のストレージである必要があります。
  </BoxAnnotation>

  <DiamondAnnotation pos="4.5 0.5 0.5" color="#00ff00">
    ソース
  </DiamondAnnotation>

  <DiamondAnnotation pos="0.5 0.5 0.5" color="#00ff00">
    出力先
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<ItemLink id="import_bus" /> (1) はソースのインベントリからアイテムや液体をネットワークストレージへインポートします。  
ただし、このネットワークの唯一のストレージが <ItemLink id="storage_bus" /> (2) のため、結果としてアイテムは出力先のインベントリへ移動します。  
電力は <ItemLink id="quartz_fiber" /> を通して供給します。

---

## ストレージバス → エクスポートバス

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/storage_export_pipe.snbt" />

  <BoxAnnotation color="#dddddd" min="3.7 0 0" max="4 1 1">
    (1) ストレージバス：フィルター可能。これが唯一のストレージである必要があります。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 1">
    (2) エクスポートバス：フィルター必須。
  </BoxAnnotation>

  <DiamondAnnotation pos="4.5 0.5 0.5" color="#00ff00">
    ソース
  </DiamondAnnotation>

  <DiamondAnnotation pos="0.5 0.5 0.5" color="#00ff00">
    出力先
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<ItemLink id="export_bus" /> はネットワークストレージからアイテムを取り出して出力先インベントリに搬入します。  
ネットワークの唯一のストレージが <ItemLink id="storage_bus" /> なので、ソースインベントリからアイテムを取り出すような動作になります。

---

## 機能しない構成：インポートバス → エクスポートバス

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/import_export_pipe.snbt" />

  <BoxAnnotation color="#dd3333" min="3.7 0 0" max="4 1 1">
    インポートバス：ストレージが無いため、何もインポートできません。
  </BoxAnnotation>

  <BoxAnnotation color="#dd3333" min="1 0 0" max="1.3 1 1">
    エクスポートバス：ストレージが無いため、何も出力できません。
  </BoxAnnotation>

  <DiamondAnnotation pos="4.5 0.5 0.5" color="#ff0000">
    ソース
  </DiamondAnnotation>

  <DiamondAnnotation pos="0.5 0.5 0.5" color="#ff0000">
    出力先
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

この構成ではネットワーク上にストレージが存在しないため、インポートバスはアイテムを取り込めず、エクスポートバスも取り出すことができません。結果として何も起きません。

---

## 1つの面で入出力を行う構成

一部の機械（例：<ItemLink id="charger" />）は、1つの面でアイテムの入力と出力を処理できます。  
この場合、2つの方法を組み合わせて双方向通信が可能です。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/import_storage_export_pipe.snbt" />

  <BoxAnnotation color="#dddddd" min="4 1 1" max="5 1.3 2">
    (1) インポートバス：フィルター可能。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 1 1" max="3 1.3 2">
    (2) ストレージバス：フィルター可能。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 0 1" max="3 1 2">
    (3) 入出力する対象：例としてチャージャー。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 1" max="1 1.3 2">
    (4) エクスポートバス：フィルター必須。
  </BoxAnnotation>

  <DiamondAnnotation pos="4.5 0.5 1.5" color="#00ff00">
    ソース
  </DiamondAnnotation>

  <DiamondAnnotation pos="0.5 0.5 1.5" color="#00ff00">
    出力先
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

---

## インターフェースの活用

<ItemLink id="interface" /> もネットワークストレージとのやり取りを行うデバイスです。  
アイテムが設定されていない場合、アイテムはネットワークへ送られます（＝インポートバスのように動作）。  
設定されたアイテムはネットワークから取り出して維持されます（＝エクスポートバスのように動作）。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/interface_pipes.snbt" />

  <BoxAnnotation color="#dddddd" min="3.7 0 0" max="4 1 1">
    インターフェース
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 1">
    ストレージバス
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3.7 0 2" max="4 1 3">
    ストレージバス
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 2" max="1 1.3 3">
    インターフェース
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

---

## 1対多、または多対1（または多対多）

<ItemLink id="import_bus" /> や <ItemLink id="export_bus" />、<ItemLink id="storage_bus" /> は複数同時に使えます。

<GameScene zoom="3" background="transparent">
  <ImportStructure src="../assets/assemblies/many_to_many_pipe.snbt" />
  <IsometricCamera yaw="185" pitch="30" />
</GameScene>

---

## 複数の場所に素材を供給する構成

1つの <ItemLink id="pattern_provider" /> から複数の機械や面へ素材を供給したい場合、以下のような構成が可能です。

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/provider_interface_storage.snbt" />

  <BoxAnnotation color="#dddddd" min="2.7 0 1" max="3 1 2">
    フラットモードのインターフェース
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 4">
    ストレージバスたち
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 0 0" max="1 1 4">
    素材を供給したい機械（または機械の面）
  </BoxAnnotation>

  <IsometricCamera yaw="185" pitch="30" />
</GameScene>
