---
navigation:
  parent: example-setups/example-setups-index.md
  title: かまど自動化
  icon: minecraft:furnace
---

# かまど自動化

<ItemLink id="pattern_provider" />を使用しているため、[自動クラフティング](../ae2-mechanics/autocrafting.md)の設定に統合することを想定しています。<ItemLink id="minecraft:furnace" />単体の自動化が目的であれば、ホッパーやチェストなどを使う方が簡単です。

<ItemLink id="minecraft:furnace" />の自動化は、[チャージャー](../example-setups/charger-automation.md)のような単純な機械に比べて少し複雑です。  
かまどは以下のように、3つの異なる面から入出力を行う必要があります。

- 上面：精錬対象アイテムの投入
- 側面：燃料の投入
- 底面：出力アイテムの取り出し

通常、これを行うには、<ItemLink id="pattern_provider" />を上部に設置し、<ItemLink id="export_bus" />で側面に燃料を常時投入し、<ItemLink id="import_bus" />で底面からアイテムを回収します。しかしこれでは[チャンネル](../ae2-mechanics/channels.md)を3つ消費してしまいます。

以下の構成では、チャンネルを1つだけ使用して実現できます：

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/furnace_automation.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 0" max="2 1 1">
        (1) パターンプロバイダー：<ItemLink id="certus_quartz_wrench" />を使って向きを設定し、関連する処理パターンを登録しています。

        ![鉄インゴットパターン](../assets/diagrams/furnace_pattern_small.png)
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 0" max="2 1.3 1">
        (2) インターフェース：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 0" max="1.3 2 1">
        (3) ストレージバス#1：<ItemImage id="minecraft:coal" scale="2" />をフィルターに設定（燃料用）。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 2 0" max="1 2.3 1">
        (4) ストレージバス#2：<ItemImage id="minecraft:coal" scale="2" />をブラックリストに設定、<ItemImage id="inverter_card" scale="2" />を使用。
        <Row><ItemImage id="minecraft:coal" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>
  </BoxAnnotation>

  <DiamondAnnotation pos="4 0.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* <ItemLink id="pattern_provider" />(1) はデフォルト設定のままで、必要な<ItemLink id="processing_pattern" />を登録します。  
  <ItemLink id="certus_quartz_wrench" />を使って向きを調整してください。

  ![鉄インゴットパターン](../assets/diagrams/furnace_pattern.png)

* <ItemLink id="interface" />(2) はデフォルト設定のままです。  
* <ItemLink id="storage_bus" />(3) は燃料（石炭など）をフィルターに設定します。  
* <ItemLink id="storage_bus" />(4) は燃料をブラックリストに設定し、<ItemLink id="inverter_card" />を使用します。  

## 仕組み

1. <ItemLink id="pattern_provider" /> が素材を <ItemLink id="interface" /> にプッシュします。  
   （実際には、最適化によりストレージバスを経由して直接搬入され、素材はインターフェースを通過しません。）  
2. インターフェースは何も保持しない設定のため、素材は[ネットワークストレージ](../ae2-mechanics/import-export-storage.md)に送られようとします。  
3. 緑のサブネット上の唯一のストレージは2つの <ItemLink id="storage_bus" /> です。  
   - 石炭にフィルターされたバスが、側面から燃料スロットに投入します。  
   - 石炭以外にフィルターされたバスが、上面から精錬対象アイテムを投入します。  
4. <ItemLink id="minecraft:furnace" /> が精錬を実行します。  
5. ホッパーが底面から精錬結果を引き出し、プロバイダーの返却スロットに送って、メインネットワークへ戻します。  
