---
navigation:
  parent: example-setups/example-setups-index.md
  title: バケツ充填機
  icon: minecraft:water_bucket
---

# バケツ充填機

また、[バケツ排出機](bucket-emptier.md)も参照してください。

この構成は<ItemLink id="pattern_provider" />を使用するため、[自動クラフティング](../ae2-mechanics/autocrafting.md)の設定に統合することを想定しています。

時には流体そのものではなく流体入りのバケツが必要になることがあります。Fluid Transposer（Thermal Expansion）などの機械があれば便利ですが、常に適切なモッドを導入しているとは限りません。幸いバニラのMinecraftにはやや不便ながらも<ItemLink id="minecraft:dispenser" />を使った方法があります。

**なお、[パターンエンコーディングターミナル](../items-blocks-machines/terminals.md#pattern-encoding-terminal)のFluid Substitutionsを使えば、クラフトレシピでバケツではなく流体そのものを使用できる場合が多いため、必ずしもこの方法を実行する必要はありません。**

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/bucket_filler.snbt" />

  <BoxAnnotation color="#dddddd" min="2 1 0" max="3 2 1">
        (1) MEパターンプロバイダー：クラフトを「レッドストーン信号あり」でロックし、関連する処理パターンを登録します。

        <Row>
        ![水充填パターン](../assets/diagrams/water_fill_pattern_small.png)
        ![溶岩充填パターン](../assets/diagrams/lava_fill_pattern_small.png)
        </Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1.1 0.1" max="3.2 1.9 0.9">
        (2) MEインターフェース：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3.1 1.1 0.8" max="3.9 1.9 1">
        (3) MEストレージバス#1：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4.05 1.05 0.8" max="4.95 1.95 1">
        (4) MEフォーメーションプレーン：インバーターカードを使用してバケツをブラックリストに設定しています。
        <Row><ItemImage id="minecraft:bucket" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3.2 2 1.2" max="3.8 2.2 1.8">
        (5) MEインポートバス：インバーターカードを使用してバケツをブラックリストに設定しています。
        <Row><ItemImage id="minecraft:bucket" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.1 2 0.1" max="2.9 2.2 0.9">
        (6) MEストレージバス#2：デフォルト設定のままです。
  </BoxAnnotation>

  <DiamondAnnotation pos="0 1.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="225" pitch="45" />
</GameScene>

## 設定

* <ItemLink id="pattern_provider" />(1) はクラフトを「レッドストーン信号あり」でロックし、関連する<ItemLink id="processing_pattern" />を登録します。

    ![水充填パターン](../assets/diagrams/water_fill_pattern.png)
    ![溶岩充填パターン](../assets/diagrams/lava_fill_pattern.png)

* <ItemLink id="interface" />(2) はデフォルト設定のままです。  
* 最初の <ItemLink id="storage_bus" />(3) はデフォルト設定のままです。  
* <ItemLink id="formation_plane" />(4) はインバーターカードを使用してバケツをブラックリストに設定しています。  
  <Row><ItemImage id="minecraft:bucket" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>  
* <ItemLink id="import_bus" />(5) はインバーターカードを使用してバケツをブラックリストに設定しています。  
  <Row><ItemImage id="minecraft:bucket" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>  
* 2番目の <ItemLink id="storage_bus" />(6) はデフォルト設定のままです。  

## 仕組み

1. <ItemLink id="pattern_provider" /> が素材を <ItemLink id="interface" /> にプッシュします。（実際には最適化により、ストレージバスとフォーメーションプレーンを介して直接プッシュされ、アイテムはインターフェースに入らないようになっています。）  
2. [パイプサブネット](pipe-subnet.md#providing-to-multiple-places)および <ItemLink id="formation_plane" /> の仕組みにより、バケツが <ItemLink id="minecraft:dispenser" /> に送られ、フォーメーションプレーンが液体を設置します。  
3. <ItemLink id="minecraft:comparator" /> がディスペンサー内のバケツを検知し、同時にディスペンサーに信号を送り、<ItemLink id="pattern_provider" /> をロックします。  
4. ディスペンサーがバケツで液体をすくい取り、内部に液体入りバケツを保持します。  
5. <ItemLink id="import_bus" /> がディスペンサーから液体入りバケツを引き出し、<ItemLink id="storage_bus" /> を介してパターンプロバイダーに戻し、メインネットワークへ返します。  
6. ディスペンサーが空になるとコンパレーターが検知し、プロバイダーのロックを解除します。  
