---
navigation:
  parent: example-setups/example-setups-index.md
  title: バケツ排出機
  icon: minecraft:bucket
---

# バケツ排出機

また、[Bucket Filler](bucket-filler.md)も参照してください。

この構成は<ItemLink id="pattern_provider" />を使用するため、[自動クラフティング](../ae2-mechanics/autocrafting.md)の設定に統合することを想定しています。

時には液体そのものが必要なのにバケツでしか作れない場合があります。Fluid Transposer（Thermal Expansion）などの機械があれば便利ですが、常に便利なモッドを持っているとは限りません。幸いバニラのMinecraftにはやや不便ながらも<ItemLink id="minecraft:dispenser" />を使った方法があります。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/bucket_emptier.snbt" />

  <BoxAnnotation color="#dddddd" min="2 1 0" max="3 2 1">
        (1) MEパターンプロバイダー：クラフトを「レッドストーン信号あり」でロックし、ブロッキングモードをオンに設定、関連する処理パターンを登録します。

        <Row>
        ![空パターン](../assets/diagrams/water_empty_pattern_small.png)
        ![空パターン](../assets/diagrams/lava_empty_pattern_small.png)
        </Row>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.1 2 0.1" max="2.9 2.2 0.9">
        (2) MEインターフェース：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3.1 2 1.1" max="3.9 2.2 1.9">
        (3) MEストレージバス#1：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4.05 1.05 0.8" max="4.95 1.95 1">
        (4) ME殲滅プレーン：GUIの設定はできません。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3.2 1.2 0.8" max="3.8 1.8 1">
        (5) MEインポートバス：<ItemImage id="minecraft:bucket" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1.1 0.1" max="3.2 1.9 0.9">
        (6) MEストレージバス#2：デフォルト設定のままです。
  </BoxAnnotation>

  <DiamondAnnotation pos="0 1.5 0.5" color="#00ff00">
        メインネットワークへ
  </DiamondAnnotation>

  <IsometricCamera yaw="225" pitch="45" />
</GameScene>

## 設定

* <ItemLink id="pattern_provider" />(1) はクラフトを「レッドストーン信号あり」でロックし、ブロッキングモードをオンに設定、関連する<ItemLink id="processing_pattern" />を登録します。

    ![チャージャーパターン](../assets/diagrams/water_empty_pattern.png)
    ![チャージャーパターン](../assets/diagrams/lava_empty_pattern.png)

* <ItemLink id="interface" />(2) はデフォルト設定のままです。
* 最初の<ItemLink id="storage_bus" />(3) はデフォルト設定のままです。
* <ItemLink id="annihilation_plane" />(4) はGUIの設定ができません。
* <ItemLink id="import_bus" />(5) はバケツ(<ItemImage id="minecraft:bucket" scale="2" />)をフィルターに設定しています。
* 2番目の<ItemLink id="storage_bus" />(6) はデフォルト設定のままです。

## 仕組み

1. <ItemLink id="pattern_provider" /> が素材を<ItemLink id="interface" />にプッシュします（実際には最適化によりストレージバス経由で直接プッシュされ、素材はインターフェースを経由しません）。
2. [パイプサブネット](pipe-subnet.md#providing-to-multiple-places)の仕組みにより、バケツが<ItemLink id="minecraft:dispenser" />に送られます。
3. <ItemLink id="minecraft:comparator" />がディスペンサー内のバケツを検知し、同時にディスペンサーに信号を送り、<ItemLink id="pattern_provider" />をロックします。
4. ディスペンサーがバケツから液体を排出し、空のバケツがディスペンサー内に残ります。
5. <ItemLink id="import_bus" />がディスペンサーから空バケツを引き出し、<ItemLink id="storage_bus" />を経由してパターンプロバイダーに戻し、メインネットワークへ返します。
6. ディスペンサーが空になるとレッドストーンコンパレーターが検知し、プロバイダーのロックを解除します。
