---
navigation:
  parent: example-setups/example-setups-index.md
  title: アメジストファーム
  icon: minecraft:amethyst_shard
---

# アメジストの栽培

<ItemLink id="growth_accelerator" />はアメジストにも作用しますが、<ItemLink id="annihilation_plane" />を使った[芽生えたサータスクォーツ](../items-blocks-machines/budding_certus.md)の通常のフィルター方法はアメジストの芽には機能しません。未成熟の芽生えたサータスクォーツは<ItemLink id="certus_quartz_dust" />をドロップしますが、未成熟のアメジストの芽は何もドロップしないため、ネットワークは「何もない」を常に保存でき、殲滅プレーンは常にそれらを破壊してしまいます。

この問題を回避するには、殲滅プレーンにシルクタッチを付与します。そうすると、未成熟のアメジストの芽は*実際に*物理ブロックとして各成長段階のブロックをドロップするため、フィルターできるようになります。

その後、<ItemLink id="minecraft:amethyst_cluster" />を<ItemLink id="formation_plane" />で再度設置し、シルクタッチなしの<ItemLink id="annihilation_plane" />で再破壊して<ItemLink id="minecraft:amethyst_shard" />を収集します。

クラスターの向きの関係上、フォーメーションプレーンの正面には必ず固体ブロックの面が配置されている必要があります。

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/amethyst_farm.snbt" />

  <BoxAnnotation color="#dddddd" min="2.7 1 1" max="3 2 2">
        (1) 殲滅プレーン#1：GUIの設定はできませんが、シルクタッチが付与されています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 1 1" max="2.3 2 2">
        (2) フォーメーションプレーン：<ItemImage id="minecraft:amethyst_cluster" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 0.7 1" max="2 1 2">
        (3) 殲滅プレーン#2：GUIの設定はできませんが、幸運（Fortune）を付与できます。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 0 1" max="1.3 1 2">
        (4) MEストレージバス#1：<ItemImage id="minecraft:amethyst_shard" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 0 .7" max="1 1 1">
        (5) MEストレージバス#2：<ItemImage id="minecraft:amethyst_shard" scale="2" />をフィルターに設定しており、メインストレージより高い優先度に設定しています。
  </BoxAnnotation>

<DiamondAnnotation pos="0 0.5 0.5" color="#00ff00">
        メインネットワークへ
</DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 設定

* GUIを設定できない最初の <ItemLink id="annihilation_plane" />(1) には、シルクタッチを付与する必要があります。
* <ItemLink id="formation_plane" />(2) は <ItemLink id="minecraft:amethyst_cluster" />をフィルターに設定しています。
* GUIを設定できない2番目の <ItemLink id="annihilation_plane" />(3) には、幸運（Fortune）を付与できます。
* <ItemLink id="storage_bus" />(4) は <ItemLink id="minecraft:amethyst_shard" />をフィルターに設定しています。
* <ItemLink id="storage_bus" />(5) は <ItemLink id="minecraft:amethyst_shard" />をフィルターに設定しており、[優先度](../ae2-mechanics/import-export-storage.md#storage-priority)をメインストレージより高く設定しています。

## 仕組み

1. 最初の <ItemLink id="annihilation_plane" /> は前方のブロックを破壊しようとしますが、サブネット上で唯一のストレージである <ItemLink id="formation_plane" /> が <ItemLink id="minecraft:amethyst_cluster" /> にフィルター設定されているため、<ItemLink id="minecraft:amethyst_cluster" /> のみを破壊できます。シルクタッチがないと未成熟の芽は何もドロップしないため、誤って破壊してしまいます。
2. <ItemLink id="formation_plane" /> が正面のブロックにクラスターを設置します。
3. 2番目の <ItemLink id="annihilation_plane" /> がクラスターを破壊し、<ItemLink id="minecraft:amethyst_shard" /> を生成します。
4. 最初の <ItemLink id="storage_bus" /> は壺にシャードを保管します。2番目の殲滅プレーンが遭遇するのは完全に成熟したクラスターのみのため、フィルターは技術的に不要です。
5. 2番目の <ItemLink id="storage_bus" /> はメインネットワークに樽内のすべての <ItemLink id="minecraft:amethyst_shard" /> へのアクセスを提供します。[優先度](../ae2-mechanics/import-export-storage.md#storage-priority)を高く設定しているため、アメジストシャードはメインストレージではなく樽に優先的に戻されます。
