---
navigation:
  parent: example-setups/example-setups-index.md
  title: 上級サータスクォーツファーム
  icon: certus_quartz_crystal
  position: 120
---

# 上級サータスクォーツファーム

これは基本的に[半自動サータスクォーツファーム](semiauto-certus-farm.md)と同じですが、MEシステムへ完全に統合されています。

大量の芽生えたサータスクォーツを溜めて手動で更新する代わりに、この構成では[チャージャー自動化](charger-automation.md)と[水中投入自動化](throw-in-water-automation.md)を使用して自動化しています。

推定速度については[サータスクォーツの成長](../ae2-mechanics/certus-growth.md)を参照してください。

**これは複雑な構造で、要素が隠れている部分もあるため、あらゆる角度からパンして確認してください**

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/advanced_certus_farm.snbt" />

  <BoxAnnotation color="#ddaaaa" min="3.7 2 1" max="4 3 2">
        (1) ME殲滅プレーン#1：GUIを設定することはできませんが、幸運（Fortune）を付与できます。
  </BoxAnnotation>

  <BoxAnnotation color="#ddaaaa" min="2 2 1.7" max="3 3 2">
        (2) MEストレージバス#1：<ItemImage id="certus_quartz_crystal" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 2.5 1.5" color="#ff0000">
    クラスター破壊サブネット
  </DiamondAnnotation>

  <BoxAnnotation color="#aaddaa" min="3.7 1 1" max="4 2 2">
        (3) ME殲滅プレーン#2：GUIを設定することはできませんが、シルクタッチ（Silk Touch）を付与する必要があります。
  </BoxAnnotation>

  <BoxAnnotation color="#aaddaa" min="2 1 1.7" max="3 2 2">
        (4) MEストレージバス#2：<BlockImage id="quartz_block" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 1.5 1.5" color="#00ff00">
    サータスクォーツブロック破壊サブネット
  </DiamondAnnotation>

  <BoxAnnotation color="#ffddaa" min="4 0.7 1" max="5 1 2">
        (5) MEフォーメーションプレーン：デフォルト設定のままです。
  </BoxAnnotation>

  <BoxAnnotation color="#ffddaa" min="2 0.7 2" max="3 1 3">
        (6) MEインポートバス：<BlockImage id="flawed_budding_quartz" scale="2" />をフィルターに設定しています。
  </BoxAnnotation>

  <DiamondAnnotation pos="3 0.5 1.5" color="#ddcc00">
    芽生えたブロック配置サブネット
  </DiamondAnnotation>

  <BoxAnnotation color="#aaaadd" min="1.7 2 2" max="2 3 3">
        (7) MEストレージバス#3：<ItemImage id="certus_quartz_crystal" scale="2" />をフィルターに設定しており、メインストレージより優先度を高く設定しています。
  </BoxAnnotation>

  <BoxAnnotation color="#aaaadd" min="2 1 2" max="3 2 3">
        (8) MEインターフェース：内部に不完全な芽生えたサータスクォーツを1つ保持する設定にしており、クラフトカードを装着しています。
        <Row><BlockImage id="flawed_budding_quartz" scale="2" /> <ItemImage id="crafting_card" scale="2" /></Row>
  </BoxAnnotation>

<DiamondAnnotation pos="1.5 0.5 0" color="#00ff00">
        メインネットワーク、チャージャー自動化、水中投入自動化へ
        <Row>
        <GameScene zoom="3" background="transparent">
          <ImportStructure src="../assets/assemblies/charger_automation.snbt" />
          <IsometricCamera yaw="195" pitch="30" />
        </GameScene>
        <GameScene zoom="3" background="transparent">
          <ImportStructure src="../assets/assemblies/throw_in_water.snbt" />
          <IsometricCamera yaw="195" pitch="30" />
        </GameScene>
        </Row>
    </DiamondAnnotation>

  <IsometricCamera yaw="165" pitch="5" />
</GameScene>

## 設定

### クラスター破壊サブネット：

* GUIを設定できない最初の <ItemLink id="annihilation_plane" />(1) には、幸運（Fortune）を付与できます。
* フィルター設定されている最初の <ItemLink id="storage_bus" />(2) は <ItemLink id="certus_quartz_crystal" /> を対象とします。

### サータスクォーツブロック破壊サブネット：

* GUIを設定できない2番目の <ItemLink id="annihilation_plane" />(3) には、シルクタッチ（Silk Touch）を付与する必要があります。
* フィルター設定されている2番目の <ItemLink id="storage_bus" />(4) は <ItemLink id="quartz_block" /> を対象とします。

### 芽生えたブロック配置サブネット：

* 使用する <ItemLink id="formation_plane" />(5) はデフォルト設定のままです。
* フィルター設定する <ItemLink id="import_bus" />(6) は <ItemLink id="flawed_budding_quartz" /> を対象とします。

### メインネットワーク上：

* 提供している <ItemLink id="storage_bus" />(7) は樽内のすべての <ItemLink id="certus_quartz_crystal" /> へのアクセスをメインネットワーク（および[チャージャー自動化](charger-automation.md)）に可能にします。優先度を[高](../ae2-mechanics/import-export-storage.md#storage-priority)に設定しているため、サータスクォーツはメインストレージではなく樽に優先的に戻されます。
* 設定された <ItemLink id="interface" />(8) は不完全な芽生えたサータスクォーツを1つ保持し、クラフトカードを装備しています。

## 仕組み

### クラスター破壊サブネット：

クラスター破壊サブネットの動作は[シンプルサータスクォーツファーム](simple-certus-farm.md)のサブネットと非常に似ています。

1. <ItemLink id="annihilation_plane" /> は前方のブロックを破壊しようとしますが、サブネット上で唯一のストレージである <ItemLink id="storage_bus" /> が <ItemLink id="certus_quartz_crystal" /> にフィルター設定されているため、<ItemLink id="quartz_cluster" /> のみを破壊できます。
2. <ItemLink id="storage_bus" /> は樽に <ItemLink id="certus_quartz_crystal" /> を保管します。

### サータスクォーツブロック破壊サブネット：

サータスクォーツブロック破壊サブネットは、劣化した芽生えたサータスクォーツが通常の <BlockImage id="quartz_block" /> に変化した後にそれを破壊するためのものです。クラスター破壊サブネットと同様に動作します。

1. <ItemLink id="annihilation_plane" /> は前方のブロックを破壊しようとしますが、唯一のストレージである <ItemLink id="storage_bus" /> が <BlockImage id="quartz_block" /> にフィルター設定されているため、<ItemLink id="quartz_block" /> のみを破壊できます。プレーンにはシルクタッチ（Silk Touch）を付与しておく必要があり、これにより芽生えたサータスクォーツブロックが破壊時に劣化せず、未成熟なブロックを誤って破壊するのを防ぎます。
2. <ItemLink id="storage_bus" /> はサータスクォーツブロックを <ItemLink id="interface" /> に保管し、[水中投入自動化](throw-in-water-automation.md)がそれを利用して新しい <ItemLink id="flawed_budding_quartz" /> を生成できるようにします。

### 芽生えたブロック配置サブネット：

芽生えたブロック配置サブネットは、破壊サブネットが古い劣化した芽生えたサータスクォーツを破壊した際に、新しい <ItemLink id="flawed_budding_quartz" /> を設置する役割を果たします。

1. <ItemLink id="import_bus" /> は <ItemLink id="interface" /> から芽生えたサータスクォーツをネットワークストレージにインポートします。
2. サブネット上で唯一のストレージである <ItemLink id="formation_plane" /> が芽生えたサータスクォーツを配置します。

### メインネットワーク上：

* <ItemLink id="storage_bus" /> は樽内のすべての <ItemLink id="certus_quartz_crystal" /> へのアクセスをメインネットワーク（および[チャージャー自動化](charger-automation.md)）に提供します。優先度を[高](../ae2-mechanics/import-export-storage.md#storage-priority)に設定しているため、サータスクォーツはメインストレージではなく樽に優先的に戻されます。
* <ItemLink id="interface" /> は芽生えたブロック配置サブネットに不完全な芽生えたサータスクォーツへのアクセスを提供し、サータスクォーツブロック破壊サブネットには劣化したブロックをメインネットワークへ戻す手段を提供します。さらに <ItemLink id="crafting_card" /> により、メインネットワークの[自動クラフティング](../ae2-mechanics/autocrafting.md)から新しい芽生えたブロックを要求できます。
