---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: サブネットワーク
---

# サブネットワーク

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/subnet_demonstration.snbt" />

<DiamondAnnotation pos="6.5 2.5 0.5" color="#00ff00">
        アイテムパイプサブネット
    </DiamondAnnotation>

<DiamondAnnotation pos="5.5 2.5 0.5" color="#00ff00">
        液体パイプサブネット
    </DiamondAnnotation>

<DiamondAnnotation pos="4.5 2.5 0.5" color="#00ff00">
        フィルタ付き消滅プレーン
    </DiamondAnnotation>

<DiamondAnnotation pos="3.5 2.5 0.5" color="#00ff00">
        形成プレーンサブネット
    </DiamondAnnotation>

<DiamondAnnotation pos="2.5 2.5 0.5" color="#00ff00">
        インターフェースとストレージバスの連携を利用し、メインネットワークからアクセス可能なローカルサブストレージとして機能するサブネット
    </DiamondAnnotation>

<DiamondAnnotation pos="1.5 1.5 0.5" color="#00ff00">
        充填アイテムをパターンプロバイダーに戻すためのアイテムパイプサブネット
    </DiamondAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

「サブネットワーク」はやや広義の用語ですが、メインネットワークを補助したり特定の小規模タスクを実行したりする任意の[ネットワーク](../ae2-mechanics/me-network-connections.md)を指します。通常は小規模でコントローラーを必要としません。主な用途は以下の2つです：

* デバイスがアクセスできるストレージを制限する（「パイプ」サブネット上のインポートバスがメインネットワークのストレージセルにアクセスしてアイテムを入れてしまわないようにする）  
* パターンプロバイダーの出力をインターフェース経由で複数のマシンのストレージバスに1チャネルで接続し、メインネットワークのチャネル使用量を節約する  

サブネットを構築する際に非常に重要なのは、[ネットワーク接続](../ae2-mechanics/me-network-connections.md)を正しく把握することです。インターフェースやバスを雑然と組み合わせても、フルブロックデバイスを介して依然としてメインネットワークに接続されている可能性があります。

異なる色のケーブルは、それ同士が接続しないという点以外、サブネットワーク構築には影響しません。

例としては、以下のようなものがあります：

* ゴミ箱／ヴォイドアップグレードを置き換えるAE2ネットワークを構築し、アイテムをコンポスターアレイやモッドリサイクラーへ可用性と需要に応じて自動的に振り分ける  
* 複雑なクラフト処理をサブネットワークで抽象化し、メインネットワークからは1つのマシンのように扱う  
* 遅いマシンを10台並列化し、メインネットワークからの見た目を変えずにスループットを向上させる  
* インポートバスとストレージバスでアイテムや液体を別コンテナ間で転送し、アイテム／液体パイプのように使う  
* 消滅プレーンとストレージバスを組み合わせ、破壊されたアイテムをストレージバスにのみ送ることでフィルタリングを実現する  
* インターフェースと形成プレーンを組み合わせ、インターフェースに挿入したアイテムを形成プレーンへプッシュして世界に配置またはドロップする  
* メインネットワーク上の<ItemLink id="level_emitter" />で制御された自動サータスクリスタル生成装置を構築する  
* サブストレージバス／インターフェース連携を利用し、ファームの出力をメインストレージに溢れさせずに保存する専用ストレージシステムを作成する  

サブネットワーク構築で非常に有用なのが<ItemLink id="quartz_fiber" />です。ネットワークを直接接続せずに電力を転送できるため、エネルギー受容器や電力ケーブルを至る所に配置する必要がありません。
