---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: 空間IO
  icon: spatial_storage_cell_2
---

# 空間IO

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/spatial_storage_1x1x1.snbt" />

  <BoxAnnotation color="#33dd33" min="1 1 1" max="2 2 2">
        移動する領域
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />

</GameScene>

空間IOは、ワールド内の物理的な空間領域を切り取り・貼り付けする機能です。<ItemLink id="flawless_budding_quartz" />を移動したり、拠点内の部屋で用途に応じた内部を切り替えたり、エンドポータルを移動したりすることもできます。

これは、定義した領域を空間ストレージ次元内の同じサイズの領域と*入れ替える*ことで動作します。パイロン配列内のすべてを空間ストレージ次元へ送り、次元内のすべてをパイロン配列へ送ります。

つまり、異次元間を移動する手段があれば（空間IOをテレポーターとして利用*することも*できますが、非常に複雑でやや不安定なため、本ガイドでは扱いません）、カスタムサイズのコンパクトマシンやポケット次元のように使えます。

# マルチブロック構成

空間IOを機能させ、切り取り・貼り付けする領域を定義するには、コンポーネントを特定の配置で組み上げる必要があります。

すべてのコンポーネントは同じ[ネットワーク](me-network-connections.md)上に存在する必要があり、1つのネットワークに対して空間IO構成は1つしか設置できません。そのため、[サブネットワーク](subnetworks.md)の利用を推奨します。

## 空間IOポート

<BlockImage id="spatial_io_port" p:powered="true" scale="4" />

<ItemLink id="spatial_io_port" />は空間IO操作を制御します。マルチブロック構成の統計情報を表示し、[空間セル](../items-blocks-machines/spatial_cells.md)を保持できます。

以下を表示します  
- ネットワークに蓄えられている[エネルギー](energy.md)量と最大容量を表示する  
- 操作に必要なエネルギー量を表示する。大量のエネルギーが瞬時に消費される可能性があるため、十分な[エネルギーセル](../items-blocks-machines/energy_cells.md)を用意してください  
- パイロン配列の効率を表示する  
- 定義された領域のサイズを表示する  

空間IO操作を実行するには、入力スロットに空間ストレージセルを設置し、<ItemLink id="spatial_io_port" />にレッドストーンパルスを送ります。すると、パイロン内の領域と空間ストレージ次元内の領域が*入れ替わります*。つまり、あるセットのブロックを空間ストレージ次元に送り、*その後別のブロックセットをパイロンに設置*してセルを再び入力スロットに戻し、IOポートを再度起動すると、2番目のブロックセットは消え、最初のブロックセットが再び現れます。

**注意：定義した領域内のすべてのエンティティ（あなた自身を含む）が一緒に移動します。脱出手段がない場合、暗く何もない箱状の空間ストレージ次元に閉じ込められます。** 友人へのいたずらにご活用ください！

## パイロン

<BlockImage id="spatial_pylon" p:powered_on="true" scale="4" />

<ItemLink id="spatial_pylon" />は空間IO構成の主要コンポーネントであり、影響を受ける領域を定義します。

領域は、パイロンの外側のバウンディングボックスを、全方向に1ブロック内側へ縮小した範囲で定義されます。

ルールは以下の通りです。  
- 最小サイズは3×3×3（これにより1×1×1の領域が定義されます）  
- すべての空間パイロンは外側のバウンディングボックス内に配置すること  
- すべての空間パイロンは同じネットワーク上にあること  
- すべてのパイロンの長さは最低でも2ブロックであること  

たとえば、3×3×3の領域を定義したい場合、ルール2に従い、すべてのパイロンは定義したい領域を囲む5×5×5のシェル内に配置しなければなりません。この1ブロック厚の5×5×5シェル内であれば、ほぼ任意の配置が可能です。

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/spatial_storage_3x3x3_pylon_demonstration.snbt" />

  <BoxAnnotation color="#33dd33" min="1 1 1" max="4 4 4">
        移動する領域
  </BoxAnnotation>

  <BoxAnnotation color="#3333ff" min="5 5 0" max="0 0 5">
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

より実用的な構成例は以下の通りです：

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/better_spatial_storage_3x3x3.snbt" />

  <BoxAnnotation color="#33dd33" min="1 1 1" max="4 4 4">
        移動する領域
  </BoxAnnotation>

  <BoxAnnotation color="#3333ff" min="5 5 0" max="0 0 5">
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## 効率

パイロン配列の効率は、シェル内に設置したパイロンの量によって変化します。大きな領域を囲む最小限の構成では非常に効率が低く、*数十億*AEものエネルギーを必要とする場合があります。

## セル寸法

一度[空間セル](../items-blocks-machines/spatial_cells.md)を使用すると、XYZの寸法（例：3×4×2）が永続的に確定され、空間ストレージ次元内の領域と紐付けられます。**使用後の空間セルはリセット、再フォーマット、サイズ変更ができません。** 異なる寸法で利用したい場合は新しいセルを作成してください。

これはセル名の数値とは異なり、16^3セルは最大16×16×16までの任意の寸法を設定できます。

この領域は方向性を持ち、回転させることはできません。同じ体積でも、2×2×3の領域は3×2×2の領域とは異なります。

セルのXYZ寸法がIOポートで表示される定義領域と一致しない場合、IOポートは動作しません。
