---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: インポート、エクスポート、およびストレージ
---

# インポート、エクスポート、およびストレージ

**あなたのMEシステムと世界**

AE2で重要な概念のひとつがネットワークストレージです。これは、ネットワークの内容が保存される場所で、通常は[ストレージセル](../items-blocks-machines/storage_cells.md)や<ItemLink id="storage_bus" />が接続されたインベントリが該当します。ほとんどのAE2[デバイス](../ae2-mechanics/devices.md)は、何らかの方法でこれとやり取りを行います。

たとえば、

*   <ItemLink id="import_bus" />は、アイテムをネットワークストレージにプッシュ（取り込む）します  
*   <ItemLink id="export_bus" />は、ネットワークストレージからアイテムをプル（取り出す）します  
*   <ItemLink id="interface" />は、ネットワークストレージからプルし、プッシュも行います  
*   [端末](../items-blocks-machines/terminals.md)は、アイテムを挿入または取り出したり、クラフトスロットを補充したりするときに、プッシュとプルの両方を行います  
*   <ItemLink id="storage_bus" />は、接続先インベントリをネットワークストレージとして利用するため、他のデバイスがそれを介してプッシュまたはプルを行います  

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/import_export_storage.snbt" />

  <BoxAnnotation color="#dddddd" min="8 1 1" max="9 1.3 2">
        インポートバスは、指しているインベントリからネットワークストレージにアイテムを取り込みます
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="8 2 1" max="9 3 1.3">
        インベントリから端末にアイテムを挿入すると、ネットワークへのインポートとして扱われます
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="7 0 1" max="8 1 2">
        インターフェースは、スロットが在庫用に設定されていないか、設定された在庫数を超えるアイテムがある場合、内部インベントリからネットワークにインポートします
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="6 0 1" max="7 1 2">
        パターンプロバイダーは、内部の返却スロットのインベントリからネットワークにインポートします
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 1 1" max="5 2 2">
        ドライブは、挿入されたセルをネットワークストレージとして提供します
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 1" max="4 1.3 2">
        ストレージバスは、指しているインベントリをネットワークストレージとして使用します
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 1" max="2 1.3 2">
        エクスポートバスは、ネットワークストレージから指しているインベントリにアイテムをエクスポートします
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 1" max="2 3 1.3">
        端末からアイテムを取り出すと、ネットワークのエクスポートとして扱われます
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 1" max="1 2 2">
        インターフェースは、スロットが在庫用に設定されている場合、内部インベントリにエクスポートします
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

ネットワークストレージへのプッシュやプルの動作やイベントは、自動化および物流システムを設計する際に重要です。

## ストレージ優先度

優先度は、一部のGUI右上にあるレンチアイコンをクリックして設定できます。  
ネットワークにアイテムが入ると、最初に優先度が最も高いストレージが格納先として選ばれます。同じ優先度のストレージが複数ある場合は、すでにアイテムを含んでいるストレージが優先されます。  
ホワイトリスト登録されたセルは、同じ優先度グループ内の他のストレージと比較して、すでにアイテムを含んでいるものとして扱われます。  
ストレージからアイテムを取り出す際は、優先度が最も低いストレージから取り出されます。  
この優先度システムにより、アイテムの挿入と取り出しに応じて、高優先度のストレージが先に満たされ、低優先度のストレージが先に空になります。  
