---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: エネルギー
  icon: energy_cell
---

# エネルギー

ネットワークを稼働させるにはエネルギーが必要です。ネットワークには[デバイス](../ae2-mechanics/devices.md)が直接取り出せるエネルギープールがあり、<ItemLink id="vibration_chamber" />や<ItemLink id="energy_acceptor" />（および<ItemLink id="controller" />）がこれにエネルギーを供給します。ネットワークのエネルギー統計は、ネットワーク上の任意の場所を<ItemLink id="network_tool" />で右クリックするか、コントローラーがある場合はそのコントローラーを右クリックすることで確認できます。このネットワーク全体での蓄積と分配により、エネルギー転送速度に制限はありません。そのため、デバイスは任意の量のエネルギーを取り出せ、エネルギー受容器は事実上無制限の速度でエネルギーを供給できます。唯一の制限はエネルギー貯蔵容量だけです。

## エネルギーの受け入れ

<Row>
  <BlockImage id="energy_acceptor" scale="4" />

  <GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/blocks/cable_energy_acceptor.snbt" />
  </GameScene>

  <BlockImage id="controller" p:state="online" scale="4" />

  <BlockImage id="vibration_chamber" p:active="true" scale="4" />
  
  <BlockImage id="crystal_resonance_generator" scale="4" />
</Row>

AE2は内部的にForge Energy（Forge上）やTechReborn Energy（Fabric上）をそのまま使用せず、独自の単位であるAEに変換します。この変換は一方向のみです。エネルギーは<ItemLink id="energy_acceptor" />や<ItemLink id="controller" />で変換できますが、コントローラー側面はより多くの[チャネル](../ae2-mechanics/channels.md)用に使うのがよいでしょう。エネルギーは<ItemLink id="vibration_chamber" />で生成することも、<ItemLink id="crystal_resonance_generator" />を使って受動的に生成することもできますが、AE2は他のエネルギー生成に優れたテクノロジーモッドと組み合わせて使うことを想定しています。

これらの仕組みから、拠点のエネルギー分配インフラを構築する際には、AE2ネットワークをひとつの巨大なマルチブロックマシンとして考えるのが最適です。

Forge EnergyとTechReborn Energyの変換比は以下のとおりです。

*   2 FE = 1 AE（Forge）
*   1 E  = 2 AE（Fabric）

## エネルギー貯蔵

<Row>
  <BlockImage id="energy_cell" scale="4" p:fullness="4" />

  <BlockImage id="dense_energy_cell" scale="4" p:fullness="4" />

  <BlockImage id="creative_energy_cell" scale="4" />
</Row>

言うまでもなく、ネットワークは1ティック内に貯蔵容量以上のエネルギーを取り込んだり消費したりできません。仮にネットワークが800 AEしか貯蔵できない場合、デバイスがエネルギーを要求しても最大で800 AEまでしか使用できず（ストレージが満杯の場合）、エネルギー受容器がネットワークに挿入できるエネルギーも最大で800 AEまでとなります（ストレージが空の場合）。

これはよくある問題で、小規模なネットワークをエネルギー受容器、ドライブ、ターミナル、いくつかのデバイスだけで構成し、自身のインベントリにある丸石を一斉にネットワークへ投入しようとすると発生します。丸石を1ティックですべて挿入しようとすると、ネットワークの貯蔵容量を超えるエネルギーが必要になるため、すべての丸石が挿入されず、ネットワークがエネルギー切れを起こして再起動してしまいます。

**これはエネルギーセルの追加で解決できます。**

ネットワークには、ケーブルやマシン、パーツ1つにつき25 AEの内部バッファが備わっています。

<ItemLink id="controller" />は8,000 AEの内部エネルギー貯蔵量を持っています。

<ItemLink id="energy_cell" />は200k AEを貯蔵でき、通常のネットワーク使用時の電力スパイクにも十分対応できるため、ほとんどの用途では1つで十分です。

<ItemLink id="dense_energy_cell" />は1.6M AEを貯蔵でき、ネットワークを蓄電で稼働させたい場合や、大規模な[スペーシャルストレージ](spatial-io.md)構成の巨大な瞬間的エネルギー需要に対応する際に使用します。

<ItemLink id="creative_energy_cell" />はテスト用のクリエイティブアイテムで、無制限のパワーを提供します。
