---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: チャンネル
  icon: controller
---

# チャンネル

Applied Energistics 2の[MEネットワーク](me-network-connections.md)では、[デバイス](../ae2-mechanics/devices.md)などネットワーク化されたストレージやその他のネットワークサービスを利用する機器にチャンネルが必要です。チャンネルはUSBケーブルのようなもので、コンピューターに限られたUSBポートしかないのと同様に、MEネットワークにも接続できる機器数に制限があります。ほとんどの機械やフルブロックデバイス、標準ケーブルは最大8チャンネルまでしか通せません。フルブロックデバイスや標準ケーブルは8本の「チャンネル線」を束ねたものと考えられます。一方で、[デンスケーブル](../items-blocks-machines/cables.md#dense-cable)は最大32チャンネルをサポートします。32チャンネルを伝送可能な他のデバイスは、<ItemLink id="me_p2p_tunnel" />と[Quantum Network Bridge](../items-blocks-machines/quantum_bridge.md)だけです。デバイスがチャンネルを1つ消費するたびに、USBケーブルの「線」を1本抜き取るのと同じイメージで、以降その線は使用できなくなります。

<GameScene zoom="7" interactive={true}>
  <ImportStructure src="../assets/assemblies/channel_demonstration_1.snbt" />
  <LineAnnotation color="#33ff33" from="1 .4 .7" to="2.4 .4 .7" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .6 .7" to="2.4 .6 .7" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .4 .6" to="2.6 .4 .6" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .6 .6" to="2.6 .6 .6" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .6 .6" to="2.6 .6 .6" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.4 .6 .7" to="2.4 .6 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.4 .4 .7" to="2.4 .4 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.6 .6 .6" to="2.6 .6 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.6 .4 .6" to="2.6 .4 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.1 .6 1.5" to="2.4 .6 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.6 .4 1.5" to="2.9 .4 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.6 .6 1.5" to="2.6 .9 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="2.4 .1 1.5" to="2.4 .4 1.5" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .6 .4" to="3.5 .6 .4" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .4 .4" to="3.5 .4 .4" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="3.5 .6 .4" to="3.5 .9 .4" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="3.5 .1 .4" to="3.5 .4 .4" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .6 .3" to="1.5 .6 .3" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1 .4 .3" to="1.5 .4 .3" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1.5 .6 .3" to="1.5 .9 .3" alwaysOnTop={true}/>
  <LineAnnotation color="#33ff33" from="1.5 .1 .3" to="1.5 .4 .3" alwaysOnTop={true}/>
  <LineAnnotation color="#ff3333" from="3.5 .5 .5" to="5.5 .5 .5" alwaysOnTop={true}>
    All 8 channels in the cable have been used, so the Drive does not get one.  
  </LineAnnotation>
  <DiamondAnnotation pos="3.6 0.5 0.5" color="#ff0000">
    All 8 channels in the cable have been used, so the Drive does not get one.
  </DiamondAnnotation>
  <IsometricCamera yaw="15" pitch="30" />
</GameScene>

ネットワーク上でチャンネルの使用状況やルーティングを確認するには、[スマートケーブル](../items-blocks-machines/cables.md)を使用するとケーブル上に経路と使用状況が表示されるため便利です。

各ノードを経由するごとに1⁄128 ae/tの電力を消費します。そのため、8台のデバイスを持つネットワークで96以上のノードを越える場合、<ItemLink id="controller" />を追加するとチャンネル割り当てが変わり、消費電力がむしろ減少することがあります。

注意：**チャンネルはケーブルの色と無関係**です。ケーブルの色付けは単に接続しないようにするだけです。

## チャンネルのルーティング

<ItemLink id="controller" />を使用すると、チャンネルは以下の3段階でルーティングされます。

1. 隣接する機械を経由して最も近い[標準ケーブル](../items-blocks-machines/cables.md)（ガラス、カバー付き、スマートいずれも可）まで最短経路を通る。  
2. その標準ケーブル内を最短経路で最も近い[デンスケーブル](../items-blocks-machines/cables.md)（デンスまたはデンススマート）まで通る。  
3. そのデンスケーブル内を最短経路で<ItemLink id="controller" />まで通る。  

最短経路がすでにチャンネルで満杯の場合、必要なチャンネルが確保できない機器が出ることがあります。カラードケーブルやケーブルアンカー、トンネルを駆使してチャンネルが望む経路を通るように工夫しましょう。

たとえば、ケーブルにはまだ容量があるにもかかわらず、最短経路を通ろうとしたチャンネルが一部のケーブルに集中し、他が未使用になっているために一部のドライブがチャンネルを取得できないケースがあります。

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/channel_path_length_issue.snbt" />
  <LineAnnotation color="#33ff33" from="3 .5 1.4" to="0.4 0.5 1.4" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="0.4 .5 1.4" to="0.4 0.5 3.6" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="0.4 0.5 3.6" to="1.4 0.5 3.6" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="1.4 0.5 3.6" to="1.4 0.5 5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="3 0.5 3.6" to="1.6 0.5 3.6" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="1.6 0.5 3.6" to="1.6 0.5 5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="3 .5 1.6" to="0.6 .5 1.6" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="0.6 .5 1.6" to="0.6 .5 3.4" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="0.6 .5 3.4" to="1.4 .5 3.4" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="3 .5 3.4" to="1.6 .5 3.4" alwaysOnTop={true} thickness="0.05"/>
  <BoxAnnotation color="#dddddd" min="1.2 0.2 3.2" max="1.8 0.8 3.8" alwaysOnTop={true} thickness="0.05">
    More than 8 channels attempt to route through here so some are cut off.
  </BoxAnnotation>
  <IsometricCamera yaw="90" pitch="90" />
</GameScene>

この問題はチャンネルが通る経路をより厳密に制限することで解決できます。ネットワークはツリー構造（またはブッシュ状）を維持し、ループや曖昧な経路は最小限にしましょう。

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/channel_path_length_issue_fix.snbt" />
  <IsometricCamera yaw="90" pitch="90" />
</GameScene>

## アドホックネットワーク

<ItemLink id="controller" />なしのネットワークはアドホックネットワークと見なされ、チャンネルを使用する機器を最大8台サポートできます。8台を超えると、ネットワーク上のチャンネルを使用する機器がシャットダウンします。機器を取り外すか、<ItemLink id="controller" />を追加してください。

コントローラー付きネットワークとは異なり、アドホックネットワーク上の[スマートケーブル](../items-blocks-machines/cables.md)は当該ケーブルを流れるチャンネル数ではなく、ネットワーク全体で使用中のチャンネル数を表示します。

アドホックネットワークを使用している間は、各機器がネットワーク全体で1チャンネルを使用します。これは、<ItemLink id="controller" />が最短経路に基づいてチャンネルを割り当てる方法とは大きく異なります。

## 設計

前述の[channel routing](channels.md#channel-routing)で述べたように、ネットワークはツリー状の構造を設計するのが最適です。<ItemLink id="controller" />からはデンスケーブルが、デンスケーブルからは標準ケーブルが分岐し、[デバイス](../ae2-mechanics/devices.md)は標準ケーブル上に8台以下のクラスターで配置します。

以下は避けるべき例です：

チャンネルの経路をたどると、

1. コントローラーの右側からすぐに出ると、ドライブが通常のケーブルとして動作するため8チャンネルに制限されます。ただしここではスマートケーブルを使用していないため使用中のチャンネル数を確認できません。残りは8チャンネルです。  
2. ドライブが1チャンネルを消費します。残り7チャンネルです。  
3. 2チャンネルが端子に上がります。残り5チャンネルです。  
4. さらに右に進むと、インターフェースが別のチャンネルを消費します。残り4チャンネルです。  
5. 1チャンネルがパターンプロバイダーに上がります。残り3チャンネルです。  
6. さらに右に進むと、インポートバスに1チャンネルが割り当てられます。残り2チャンネルです。  
7. アセンブラーに給仕するパターンプロバイダーのクラスターには2チャンネルしか割り当てられないため、2台のプロバイダーはチャンネルを取得できません。  

最終的な問題は、チャンネルをボトルネック化し、チャンネルの配分を考慮していないことにあります。

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/bad_network_structure.snbt" />

  <LineAnnotation color="#33ff33" from="6.5 .5 1.5" to="6 .5 1.5" alwaysOnTop={true} thickness="0.4">
    32 channels
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="6 .5 1.5" to="5.5 .5 1.5" alwaysOnTop={true} thickness="0.2">
    8 channels
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="5.5 .5 1.5" to="5.5 1.5 1.5" alwaysOnTop={true} thickness="0.1">
    2 channels
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="5.5 .5 1.5" to="5.5 .3 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="5.5 1.5 1.5" to="5.5 2.5 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="5.5 2.5 1.5" to="5.5 2.5 1.1" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="5.5 .5 1.5" to="4.5 .5 1.5" alwaysOnTop={true} thickness="0.158">
    5 channels
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="4.5 .5 1.5" to="4.5 .3 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="4.5 .5 1.5" to="4.5 1.5 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="4.5 .5 1.5" to="3.5 .5 1.5" alwaysOnTop={true} thickness="0.122">
    3 channels
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="3.5 .5 1.5" to="3.5 2.5 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="3.5 2.5 1.5" to="3.7 2.5 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="3.5 .5 1.5" to="1.5 .5 1.5" alwaysOnTop={true} thickness="0.1">
    2 channels
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="1.5 0.5 1.5" to="1.5 0.3 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="1.5 0.5 1.5" to="0.5 0.5 1.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#33ff33" from="0.5 0.5 1.5" to="0.5 0.5 0.5" alwaysOnTop={true} thickness="0.071">
    1 channel
  </LineAnnotation>

  <LineAnnotation color="#ff3333" from="0.5 1.5 1.5" to="0.5 1.3 1.5" alwaysOnTop={true} thickness="0.071">
    no channels
  </LineAnnotation>

  <LineAnnotation color="#ff3333" from="1.5 1.5 0.5" to="1.5 1.3 0.5" alwaysOnTop={true} thickness="0.071">
    no channels
  </LineAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

---

以下は理想的な構造の例です：

<GameScene zoom="2.5" interactive={true}>
  <ImportStructure src="../assets/assemblies/treelike_network_structure.snbt" />

    <BoxAnnotation color="#dddddd" min="6.9 0 4.9" max="9.1 4 7.1" thickness="0.05">
        Notice that the pattern providers are in separate groups of 8.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="5 4 4" max="8 5 5" thickness="0.05">
        Two regular cables full of channels coming together mean you need a dense cable.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="5 0 13" max="8 1 14" thickness="0.05">
        Different cable colors are used to prevent adjacent cables from connecting.
    </BoxAnnotation>

  <IsometricCamera yaw="315" pitch="30" />
</GameScene>

## チャンネルモード

Minecraft 1.18向けAE2 10.0.0では、AE2チャンネルの挙動を変更する新しいオプションが導入されました。  
設定ファイルのgeneralセクションにはこのオプションを制御する新しい設定項目（`channels`）が追加され、ゲーム内からモードと設定を変更できるオペレーター向けの新コマンドも導入されました。コマンドはモードを変更する`/ae2 channelmode <mode>`と現在のモードを表示する`/ae2 channelmode`です。  
ゲーム内でモードが変更されると、既存のグリッドはすべて再起動し、新しいモードを直ちに使用します。

これはMinecraft 1.12で利用可能だったオプションを復活・改良したもので、ゲームプレイをより気軽に楽しみつつもメカニクスを完全に取り除きたくないプレイヤーにとって優れた選択肢を提供します。

以下の表は、設定ファイルとコマンドで使用可能なモードを一覧にしています。

| 設定        | 説明                                                                                                                                                                                                                                 |
| ---------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `default`  | 標準モードであり、このサイト全体で説明されているケーブルおよびアドホックネットワークのチャンネル容量を持ちます。                                                                                                                   |
| `x2`       | すべてのチャンネル容量が2倍になります（通常ケーブルは16、デンスケーブルは64、アドホックネットワークは16チャンネルをサポート）。                                                                                               |
| `x3`       | すべてのチャンネル容量が3倍になります（通常ケーブルは24、デンスケーブルは92、アドホックネットワークは24チャンネルをサポート）。                                                                                               |
| `x4`       | すべてのチャンネル容量が4倍になります（通常ケーブルは32、デンスケーブルは128、アドホックネットワークは32チャンネルをサポート）。                                                                                               |
| `infinite` | すべてのチャンネル制限が解除されます。コントローラーはグリッドの消費電力を*大幅に*削減し続けます。スマートケーブルは完全にオフ（チャンネルがまったく伝送されない）と完全にオン（1チャンネル以上伝送される）のみを切り替えます。 |
