---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: バイトと種類
  icon: creative_storage_cell
---

# バイトと種類

<Row>
    <ItemImage id="item_storage_cell_1k" scale="4" />

    <ItemImage id="item_storage_cell_4k" scale="4" />

    <ItemImage id="item_storage_cell_16k" scale="4" />

    <ItemImage id="item_storage_cell_64k" scale="4" />

    <ItemImage id="item_storage_cell_256k" scale="4" />
  </Row>

[Storage Cells](../items-blocks-machines/storage_cells.md) は*バイト*と*種類*で定義されます。*バイト*は実際のコンピューターと同様に、ストレージセル内の「中身」の総量を示す単位です。*種類*はセルに格納される異なるアイテムの種別数を示します。各*種類*はユニークなアイテム種別を表すため、丸石4,096個は1*種類*ですが、異なるエンチャントを持つ剣16本は16*種類*になります。

各ストレージセルには格納可能なデータ量の上限が決まっています。各*種類*は前置きとして一定数のバイト（セルのサイズに応じて異なります）を消費し、各アイテムは1ビットを消費します。つまり8個のアイテムで1バイト、スタック64個で8バイトを消費します。これはMEネットワーク外でのスタック限度に影響されません。たとえば同じサドル64個は石64個と同じ8バイトしか占有しません。

繰り返しますが、各アイテムは1ビットなので、8個で1バイトです。流体セルの場合は1バイトあたり8バケツに相当します。

多くの人はセルが保持できる*種類*数の制限を不満に思いますが、これは***必要な制限***です。セルはアイテム自体のNBTタグにデータを保存するため安定性が高い一方、セルに大量のデータを持たせるとプレイヤーに送信されるデータ量が増加し、バニラMinecraftの「ブックバン」に似た現象を引き起こす可能性があります。さらに、システム内に多くの異なる*種類*を含めると、分類やアイテム処理への負荷が増大します。しかし、この制限はそれほど厳しいものではありません。セルで満たされた<ItemLink id="drive" />ベイ1つで630*種類*を保持でき、ユニークな非スタックアイテムを大量に格納しない限り十分な数です。

このため、*種類*はモブファームからドロップするランダムにダメージやエンチャントが付与された数百個もの防具やツールを直接MEシステムに流し込まないよう「強く抑止」する役割もあります。ダメージやエンチャントが異なる防具はそれぞれ別エントリとして記録され、データが膨張します。システムに触れる前にアイテムストリームから除外することを推奨します。

最上位のストレージセルを一気に目指すのは、追加の*種類*容量が増えず資源だけを多く消費するためあまりおすすめできません。各セルサイズには一長一短があり、後半でも活用価値があります。

以下は各ティアのストレージセルの容量と概算コストを比較した表です。

## ストレージセルの容量とコスト比較

| セル                                  | バイト数 | 種類数 | 1種類あたりのバイト数 | サータスクォーツ | レッドストーン | 金 | グロウストーン |
| ------------------------------------- | -------: | -----: | --------------------: | ---------------: | -------------: | -: | -------------: |
| <ItemLink id="item_storage_cell_1k" />   |   1,024 |    63 |                     8 |                4 |              5 |  1 |              0 |
| <ItemLink id="item_storage_cell_4k" />   |   4,096 |    63 |                    32 |            14.25 |             20 |  3 |              0 |
| <ItemLink id="item_storage_cell_16k" />  |  16,384 |    63 |                   128 |               45 |             61 |  9 |              4 |
| <ItemLink id="item_storage_cell_64k" />  |  65,536 |    63 |                   512 |           137.25 |            184 | 27 |             16 |
| <ItemLink id="item_storage_cell_256k" /> | 262,144 |    63 |                 2,048 |              414 |            553 | 81 |             48 |

## 種類数によるストレージセル容量

前置きの種類コストにより、1種類のみを使用したセルは、すべての63種類を使用したセルの2倍の容量を保持できます。

| セル                                  | 1種類使用時の総容量 | 63種類使用時の総容量 |
| ------------------------------------- | ------------------: | -------------------: |
| <ItemLink id="item_storage_cell_1k" />   |               8,128 |                4,160 |
| <ItemLink id="item_storage_cell_4k" />   |              32,512 |               16,640 |
| <ItemLink id="item_storage_cell_16k" />  |             130,048 |               66,560 |
| <ItemLink id="item_storage_cell_64k" />  |             520,192 |              266,240 |
| <ItemLink id="item_storage_cell_256k" /> |           2,080,768 |            1,064,960 |

![1種類のセル](../assets/diagrams/1_type_cell.png)

![63種類のセル](../assets/diagrams/63_type_cell.png)
